/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;

public class FatCatParameters
implements ConfigStrucAligParams {
    public static final int DEFAULT_FRAGLEN = 8;
    int fragLen;
    int fragLenSq;
    Double rmsdCut;
    double disCut;
    double afpDisCut;
    double afpDisCut0;
    double disSmooth;
    int misCut;
    int maxGap;
    int maxGapFrag;
    double disFilter;
    double badRmsd;
    int maxTra;
    double gapCreate;
    double gapExtend;
    double misScore;
    double torsionPenalty;
    double maxPenalty;
    double resScore;
    double fragScore;
    int sparse;
    boolean optimizeAlignment;

    public FatCatParameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.fragLen = 8;
        this.fragLenSq = this.fragLen * this.fragLen;
        this.rmsdCut = 3.0;
        this.disCut = 5.0;
        this.afpDisCut = (double)this.fragLenSq * this.disCut * this.disCut;
        this.afpDisCut0 = (double)this.fragLenSq * this.disCut;
        this.disSmooth = 4.0;
        this.misCut = 2 * this.fragLen;
        this.maxGap = 40;
        this.maxGapFrag = this.fragLen + this.maxGap;
        this.disFilter = 2.0 * this.rmsdCut;
        this.badRmsd = 4.0;
        this.maxTra = 5;
        this.gapCreate = -5.0;
        this.misScore = this.gapExtend = -0.5;
        this.torsionPenalty = 5.0 * this.gapCreate;
        this.maxPenalty = 1.0 * this.gapCreate;
        this.resScore = 3.0;
        this.fragScore = this.resScore * (double)this.fragLen;
        this.sparse = 0;
        this.optimizeAlignment = true;
    }

    public Integer getFragLen() {
        return this.fragLen;
    }

    public void setFragLen(Integer fragLen) {
        this.fragLen = fragLen;
    }

    public int getFragLenSq() {
        return this.fragLenSq;
    }

    public void setFragLenSq(int fragLenSq) {
        this.fragLenSq = fragLenSq;
    }

    public Double getRmsdCut() {
        return this.rmsdCut;
    }

    public void setRmsdCut(Double rmsdCut) {
        this.rmsdCut = rmsdCut;
    }

    public Double getDisCut() {
        return this.disCut;
    }

    public void setDisCut(Double disCut) {
        this.disCut = disCut;
    }

    public double getAfpDisCut() {
        return this.afpDisCut;
    }

    public void setAfpDisCut(double afpDisCut) {
        this.afpDisCut = afpDisCut;
    }

    public double getAfpDisCut0() {
        return this.afpDisCut0;
    }

    public void setAfpDisCut0(double afpDisCut0) {
        this.afpDisCut0 = afpDisCut0;
    }

    public double getDisSmooth() {
        return this.disSmooth;
    }

    public void setDisSmooth(double disSmooth) {
        this.disSmooth = disSmooth;
    }

    public int getMisCut() {
        return this.misCut;
    }

    public void setMisCut(int misCut) {
        this.misCut = misCut;
    }

    public int getMaxGap() {
        return this.maxGap;
    }

    public void setMaxGap(int maxGap) {
        this.maxGap = maxGap;
    }

    public int getMaxGapFrag() {
        return this.maxGapFrag;
    }

    public void setMaxGapFrag(int maxGapFrag) {
        this.maxGapFrag = maxGapFrag;
    }

    public double getDisFilter() {
        return this.disFilter;
    }

    public void setDisFilter(double disFilter) {
        this.disFilter = disFilter;
    }

    public double getBadRmsd() {
        return this.badRmsd;
    }

    public void setBadRmsd(double badRmsd) {
        this.badRmsd = badRmsd;
    }

    public Integer getMaxTra() {
        return this.maxTra;
    }

    public void setMaxTra(Integer maxTra) {
        this.maxTra = maxTra;
    }

    public double getGapCreate() {
        return this.gapCreate;
    }

    public void setGapCreate(double gapCreate) {
        this.gapCreate = gapCreate;
    }

    public double getGapExtend() {
        return this.gapExtend;
    }

    public void setGapExtend(double gapExtend) {
        this.gapExtend = gapExtend;
    }

    public double getMisScore() {
        return this.misScore;
    }

    public void setMisScore(double misScore) {
        this.misScore = misScore;
    }

    public double getTorsionPenalty() {
        return this.torsionPenalty;
    }

    public void setTorsionPenalty(double torsionPenalty) {
        this.torsionPenalty = torsionPenalty;
    }

    public double getMaxPenalty() {
        return this.maxPenalty;
    }

    public void setMaxPenalty(double maxPenalty) {
        this.maxPenalty = maxPenalty;
    }

    public double getResScore() {
        return this.resScore;
    }

    public void setResScore(double resScore) {
        this.resScore = resScore;
    }

    public double getFragScore() {
        return this.fragScore;
    }

    public void setFragScore(double fragScore) {
        this.fragScore = fragScore;
    }

    public int getSparse() {
        return this.sparse;
    }

    public void setSparse(int sparse) {
        this.sparse = sparse;
    }

    @Override
    public List<String> getUserConfigHelp() {
        ArrayList<String> params = new ArrayList<String>();
        String fragLen = "The length of the fragments.";
        String rmsdCutHelp = "The RMSD cutoff to be used during AFP detection.";
        String disCutHelp = "The distance cutoff used when calculate the connectivity of AFP pairs";
        String twistHelp = "The number of twists that are allowed to be introduced. If set to 0 alignments are run in RIGID mode.";
        params.add(fragLen);
        params.add(rmsdCutHelp);
        params.add(disCutHelp);
        params.add(twistHelp);
        return params;
    }

    @Override
    public List<String> getUserConfigParameterNames() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("Fragment Length");
        params.add("RMSD Cutoff");
        params.add("AFP Distance Cutoff");
        params.add("Maximum Nr. of twists");
        return params;
    }

    @Override
    public List<String> getUserConfigParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("FragLen");
        params.add("RmsdCut");
        params.add("DisCut");
        params.add("MaxTra");
        return params;
    }

    @Override
    public List<Class> getUserConfigTypes() {
        ArrayList<Class> params = new ArrayList<Class>();
        params.add(Integer.class);
        params.add(Double.class);
        params.add(Double.class);
        params.add(Integer.class);
        return params;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.append("[");
        if (this.maxTra == 0) {
            writer.append("Mode: rigid, ");
        } else {
            writer.append("Mode: flexible, ");
        }
        List<String> params = this.getUserConfigParameters();
        for (String s : params) {
            writer.append(s);
            writer.append(": ");
            Object val = this.getValue(s);
            writer.append(val.toString());
            writer.append(", ");
        }
        writer.append("]");
        return writer.toString();
    }

    private Object getValue(String name) {
        try {
            String methodName = "get" + name;
            Class<?> paramC = this.getClass();
            Method m = paramC.getMethod(methodName, null);
            Object value = m.invoke((Object)this, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isOptimizeAlignment() {
        return this.optimizeAlignment;
    }

    public void setOptimizeAlignment(boolean optimizeAlignment) {
        this.optimizeAlignment = optimizeAlignment;
    }
}

