/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.SeqMisMatch;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.io.FileConvert;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainImpl
implements Chain {
    private static final Logger logger = LoggerFactory.getLogger(ChainImpl.class);
    private static final long serialVersionUID = 1990171805277911840L;
    private static final String DEFAULT_CHAIN_ID = "A";
    private String swissprot_id;
    private String authId = "A";
    private List<Group> groups = new ArrayList<Group>();
    private List<Group> seqResGroups = new ArrayList<Group>();
    private EntityInfo entity;
    private Structure parent;
    private Map<String, Integer> pdbResnumMap = new HashMap<String, Integer>();
    private String asymId = null;
    private List<SeqMisMatch> seqMisMatches = null;

    @Override
    public String getId() {
        return this.asymId;
    }

    @Override
    public void setId(String asymId) {
        this.asymId = asymId;
    }

    @Override
    public String getName() {
        return this.authId;
    }

    @Override
    public void setName(String authId) {
        this.authId = authId;
    }

    @Override
    @Deprecated
    public void setParent(Structure parent) {
        this.setStructure(parent);
    }

    @Override
    public void setStructure(Structure parent) {
        this.parent = parent;
    }

    @Override
    public Structure getStructure() {
        return this.parent;
    }

    @Override
    @Deprecated
    public Structure getParent() {
        return this.getStructure();
    }

    @Override
    public Object clone() {
        ChainImpl n = new ChainImpl();
        n.setId(this.getId());
        n.setName(this.getName());
        n.setSwissprotId(this.getSwissprotId());
        n.setEntityInfo(this.entity);
        for (Group group : this.groups) {
            Group g = (Group)group.clone();
            n.addGroup(g);
            g.setChain(n);
        }
        if (this.seqResGroups != null) {
            ArrayList<Group> tmpSeqRes = new ArrayList<Group>();
            for (Group seqResGroup : this.seqResGroups) {
                if (seqResGroup == null) {
                    tmpSeqRes.add(null);
                    continue;
                }
                int i = this.groups.indexOf(seqResGroup);
                Group g = i != -1 ? n.getAtomGroup(i) : (Group)seqResGroup.clone();
                g.setChain(n);
                tmpSeqRes.add(g);
            }
            n.setSeqResGroups(tmpSeqRes);
        }
        return n;
    }

    @Override
    public void setEntityInfo(EntityInfo mol) {
        this.entity = mol;
    }

    @Override
    public EntityInfo getEntityInfo() {
        return this.entity;
    }

    @Override
    public void setSwissprotId(String sp_id) {
        this.swissprot_id = sp_id;
    }

    @Override
    public String getSwissprotId() {
        return this.swissprot_id;
    }

    @Override
    public void addGroup(Group group) {
        group.setChain(this);
        for (Group g : group.getAltLocs()) {
            g.setChain(this);
        }
        this.groups.add(group);
        String pdbResnum = null;
        ResidueNumber resNum = group.getResidueNumber();
        if (resNum != null) {
            pdbResnum = resNum.toString();
        }
        if (pdbResnum != null) {
            Integer pos = this.groups.size() - 1;
            if (this.pdbResnumMap.containsKey(pdbResnum)) {
                logger.warn("Adding residue {}({}) to chain {} but a residue with same residue number is already present: {}({}). Will add only the aminoacid residue (if any) to the lookup, lookups for that residue number won't work properly.", new Object[]{pdbResnum, group.getPDBName(), this.getChainID(), this.groups.get(this.pdbResnumMap.get(pdbResnum)).getResidueNumber(), this.groups.get(this.pdbResnumMap.get(pdbResnum)).getPDBName()});
                if (group instanceof AminoAcid) {
                    this.pdbResnumMap.put(pdbResnum, pos);
                }
            } else {
                this.pdbResnumMap.put(pdbResnum, pos);
            }
        }
    }

    @Override
    public Group getAtomGroup(int position) {
        return this.groups.get(position);
    }

    @Override
    public List<Group> getAtomGroups(GroupType type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (Group g : this.groups) {
            if (!g.getType().equals((Object)type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    @Override
    public List<Group> getAtomGroups() {
        return this.groups;
    }

    @Override
    public void setAtomGroups(List<Group> groups) {
        for (Group g : groups) {
            g.setChain(this);
        }
        this.groups = groups;
    }

    @Override
    public Group[] getGroupsByPDB(ResidueNumber start, ResidueNumber end, boolean ignoreMissing) throws StructureException {
        boolean foundStart;
        boolean adding;
        if (start == null && end == null) {
            return this.groups.toArray(new Group[this.groups.size()]);
        }
        ArrayList<Group> retlst = new ArrayList<Group>();
        if (start == null) {
            adding = true;
            foundStart = true;
        } else {
            adding = false;
            foundStart = false;
        }
        for (Group g : this.groups) {
            ResidueNumber pos;
            if (!adding && start.equalsPositional(g.getResidueNumber())) {
                adding = true;
                foundStart = true;
            }
            if (!(!ignoreMissing || foundStart && adding)) {
                pos = g.getResidueNumber();
                if (start != null && start.compareToPositional(pos) <= 0) {
                    foundStart = true;
                    adding = true;
                }
            }
            if (adding) {
                retlst.add(g);
            }
            if (end != null && end.equalsPositional(g.getResidueNumber())) {
                if (!adding) {
                    throw new StructureException("did not find start PDB residue number " + start + " in chain " + this.authId);
                }
                adding = false;
                break;
            }
            if (!ignoreMissing || !adding || end == null || end.compareToPositional(pos = g.getResidueNumber()) > 0) continue;
            adding = false;
            break;
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + start + " in chain " + this.authId);
        }
        if (end != null && adding && !ignoreMissing) {
            throw new StructureException("did not find end PDB residue number " + end + " in chain " + this.authId);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    @Override
    public Group getGroupByPDB(ResidueNumber resNum) throws StructureException {
        String pdbresnum = resNum.toString();
        if (this.pdbResnumMap.containsKey(pdbresnum)) {
            Integer pos = this.pdbResnumMap.get(pdbresnum);
            return this.groups.get(pos);
        }
        throw new StructureException("unknown PDB residue number " + pdbresnum + " in chain " + this.authId);
    }

    @Override
    public Group[] getGroupsByPDB(ResidueNumber start, ResidueNumber end) throws StructureException {
        return this.getGroupsByPDB(start, end, false);
    }

    @Override
    public int getSeqResLength() {
        return this.seqResGroups.size();
    }

    @Override
    public void setChainID(String asymId) {
        this.asymId = asymId;
    }

    @Override
    public String getChainID() {
        return this.asymId;
    }

    @Override
    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder str = new StringBuilder();
        str.append("Chain asymId:").append(this.getChainID()).append(" authId:").append(this.getName()).append(newline);
        if (this.entity != null && this.entity.getDescription() != null) {
            str.append(this.entity.getDescription()).append(newline);
        }
        str.append("total SEQRES length: ").append(this.getSeqResGroups().size()).append(" total ATOM length:").append(this.getAtomLength()).append(" residues ").append(newline);
        return str.toString();
    }

    @Override
    public Sequence<?> getBJSequence() {
        String seq = this.getSeqResSequence();
        ProteinSequence s = null;
        try {
            s = new ProteinSequence(seq);
        }
        catch (CompoundNotFoundException e) {
            logger.error("Could not create sequence object from seqres sequence. Some unknown compound: {}", (Object)e.getMessage());
        }
        return s;
    }

    @Override
    public String getAtomSequence() {
        List<Group> groups = this.getAtomGroups();
        StringBuilder sequence = new StringBuilder();
        for (Group g : groups) {
            ChemComp cc = g.getChemComp();
            if (!PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) && !PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) continue;
            String oneLetter = ChemCompGroupFactory.getOneLetterCode(cc);
            if (oneLetter == null) {
                oneLetter = Character.toString('X');
            }
            sequence.append(oneLetter);
        }
        return sequence.toString();
    }

    @Override
    public String getSeqResSequence() {
        StringBuilder str = new StringBuilder();
        for (Group g : this.seqResGroups) {
            ChemComp cc = g.getChemComp();
            if (cc == null) {
                logger.warn("Could not load ChemComp for group: ", (Object)g);
                str.append('X');
                continue;
            }
            if (PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) || PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) {
                String oneLetter = ChemCompGroupFactory.getOneLetterCode(cc);
                if (oneLetter == null || oneLetter.isEmpty() || oneLetter.equals("?")) {
                    oneLetter = Character.toString('X');
                }
                str.append(oneLetter);
                continue;
            }
            str.append('X');
        }
        return str.toString();
    }

    public String getSeqResOneLetterSeq() {
        StringBuilder str = new StringBuilder();
        for (Group g : this.seqResGroups) {
            ChemComp cc = g.getChemComp();
            if (cc == null) {
                logger.warn("Could not load ChemComp for group: ", (Object)g);
                str.append('X');
                continue;
            }
            if (PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) || PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) {
                String oneLetter = ChemCompGroupFactory.getOneLetterCode(cc);
                if (oneLetter == null || oneLetter.isEmpty() || oneLetter.equals("?") || oneLetter.length() != 1) {
                    oneLetter = Character.toString('X');
                }
                str.append(oneLetter);
                continue;
            }
            str.append('X');
        }
        return str.toString();
    }

    @Override
    public Group getSeqResGroup(int position) {
        return this.seqResGroups.get(position);
    }

    @Override
    public List<Group> getSeqResGroups(GroupType type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (Group g : this.seqResGroups) {
            if (!g.getType().equals((Object)type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    @Override
    public List<Group> getSeqResGroups() {
        return this.seqResGroups;
    }

    @Override
    public void setSeqResGroups(List<Group> groups) {
        for (Group g : groups) {
            if (g == null) continue;
            g.setChain(this);
        }
        this.seqResGroups = groups;
    }

    @Override
    public int getAtomLength() {
        return this.groups.size();
    }

    @Override
    public List<Group> getAtomLigands() {
        ArrayList<Group> ligands = new ArrayList<Group>();
        for (Group g : this.groups) {
            if (this.seqResGroups.contains(g) || g.isWater()) continue;
            ligands.add(g);
        }
        return ligands;
    }

    @Override
    public String getInternalChainID() {
        return this.asymId;
    }

    @Override
    public void setInternalChainID(String internalChainID) {
        this.asymId = internalChainID;
    }

    @Override
    public String toPDB() {
        return FileConvert.toPDB(this);
    }

    @Override
    public String toMMCIF() {
        return FileConvert.toMMCIF(this, true);
    }

    @Override
    public void setSeqMisMatches(List<SeqMisMatch> seqMisMatches) {
        this.seqMisMatches = seqMisMatches;
    }

    @Override
    public List<SeqMisMatch> getSeqMisMatches() {
        return this.seqMisMatches;
    }

    @Override
    public EntityType getEntityType() {
        if (this.getEntityInfo() == null) {
            return null;
        }
        return this.getEntityInfo().getType();
    }

    @Override
    public boolean isWaterOnly() {
        for (Group g : this.getAtomGroups()) {
            if (g.isWater()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPureNonPolymer() {
        for (Group g : this.getAtomGroups()) {
            if (!g.isPolymeric() || g.isHetAtomInFile()) continue;
            return false;
        }
        return true;
    }

    @Override
    public GroupType getPredominantGroupType() {
        double ratioResiduesToTotal = 0.95;
        int sizeAminos = this.getAtomGroups(GroupType.AMINOACID).size();
        int sizeNucleotides = this.getAtomGroups(GroupType.NUCLEOTIDE).size();
        List<Group> hetAtoms = this.getAtomGroups(GroupType.HETATM);
        int sizeHetatoms = hetAtoms.size();
        int sizeWaters = 0;
        for (Group g : hetAtoms) {
            if (!g.isWater()) continue;
            ++sizeWaters;
        }
        int sizeHetatomsWithoutWater = sizeHetatoms - sizeWaters;
        int fullSize = sizeAminos + sizeNucleotides + sizeHetatomsWithoutWater;
        if ((double)sizeAminos / (double)fullSize > ratioResiduesToTotal) {
            return GroupType.AMINOACID;
        }
        if ((double)sizeNucleotides / (double)fullSize > ratioResiduesToTotal) {
            return GroupType.NUCLEOTIDE;
        }
        if ((double)sizeHetatomsWithoutWater / (double)fullSize > ratioResiduesToTotal) {
            return GroupType.HETATM;
        }
        GroupType max = sizeNucleotides > sizeAminos ? (sizeNucleotides > sizeHetatomsWithoutWater ? GroupType.NUCLEOTIDE : GroupType.HETATM) : (sizeAminos > sizeHetatomsWithoutWater ? GroupType.AMINOACID : GroupType.HETATM);
        logger.debug("Ratio of residues to total for chain with asym_id {} is below {}. Assuming it is a {} chain. Counts: # aa residues: {}, # nuc residues: {}, # non-water het residues: {}, # waters: {}, ratio aa/total: {}, ratio nuc/total: {}", new Object[]{this.getId(), ratioResiduesToTotal, max, sizeAminos, sizeNucleotides, sizeHetatomsWithoutWater, sizeWaters, (double)sizeAminos / (double)fullSize, (double)sizeNucleotides / (double)fullSize});
        return max;
    }

    @Override
    public boolean isProtein() {
        return this.getPredominantGroupType() == GroupType.AMINOACID;
    }

    @Override
    public boolean isNucleicAcid() {
        return this.getPredominantGroupType() == GroupType.NUCLEOTIDE;
    }
}

