/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.repack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.repack.DependencyDefinition;
import org.basepom.mojo.repack.PluginLog;
import org.basepom.mojo.repack.Reporter;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryCoordinates;
import org.springframework.boot.loader.tools.LibraryScope;

final class ArtifactsLibraries
implements Libraries {
    private static final PluginLog LOG = new PluginLog(ArtifactsLibraries.class);
    private static final Map<String, LibraryScope> SCOPES = ImmutableMap.of((Object)"compile", (Object)LibraryScope.COMPILE, (Object)"runtime", (Object)LibraryScope.RUNTIME, (Object)"provided", (Object)LibraryScope.PROVIDED, (Object)"system", (Object)LibraryScope.PROVIDED);
    private final boolean quiet;
    private final Set<Artifact> artifacts;
    private final Set<Artifact> includedArtifacts;
    private final Collection<MavenProject> localProjects;
    private final Set<DependencyDefinition> runtimeUnpackedDependencies;
    private final Set<String> duplicates = new HashSet<String>();

    ArtifactsLibraries(boolean quiet, Set<Artifact> artifacts, Set<Artifact> includedArtifacts, Collection<MavenProject> localProjects, Set<DependencyDefinition> runtimeUnpackedDependencies) {
        this.quiet = quiet;
        this.artifacts = (Set)Preconditions.checkNotNull(artifacts, (Object)"artifacts is null");
        this.includedArtifacts = (Set)Preconditions.checkNotNull(includedArtifacts, (Object)"includedArtifacts is null");
        this.localProjects = (Collection)Preconditions.checkNotNull(localProjects, (Object)"localProjects is null");
        this.runtimeUnpackedDependencies = (Set)Preconditions.checkNotNull(runtimeUnpackedDependencies, (Object)"runtimeUnpackedDependencies is null");
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        for (Artifact artifact : this.artifacts) {
            String name = ArtifactsLibraries.createFileName(artifact);
            File file = artifact.getFile();
            LibraryScope scope = SCOPES.get(artifact.getScope());
            if (scope == null) {
                LOG.report(this.quiet, "Ignoring Dependency %s, scope is %s", artifact, artifact.getScope());
                Reporter.addExcluded(artifact, "scope");
                continue;
            }
            if (file == null) {
                LOG.report(this.quiet, "Ignoring Dependency %s, no file found!", artifact);
                Reporter.addExcluded(artifact, "nofile");
                continue;
            }
            if (this.duplicates.contains(name)) {
                LOG.warn("Ignoring Dependency %s, ignoring multiple inclusions!", artifact);
                continue;
            }
            this.duplicates.add(name);
            ArtifactLibraryCoordinates coordinates = new ArtifactLibraryCoordinates(artifact);
            boolean runtimeUnpacked = this.isRuntimeUnpacked(artifact);
            if (runtimeUnpacked) {
                Reporter.addRuntimeUnpacked(artifact);
            }
            boolean local = this.isLocal(artifact);
            boolean included = this.includedArtifacts.contains(artifact);
            if (included) {
                Reporter.addIncluded(artifact);
            }
            callback.library(new Library(name, file, scope, (LibraryCoordinates)coordinates, runtimeUnpacked, local, included));
        }
    }

    private boolean isRuntimeUnpacked(Artifact artifact) {
        for (DependencyDefinition runtimeUnpackedDependency : this.runtimeUnpackedDependencies) {
            if (!runtimeUnpackedDependency.matches(artifact)) continue;
            return true;
        }
        return false;
    }

    private boolean isLocal(Artifact artifact) {
        for (MavenProject localProject : this.localProjects) {
            if (localProject.getArtifact().equals(artifact)) {
                return true;
            }
            for (Artifact attachedArtifact : localProject.getAttachedArtifacts()) {
                if (!attachedArtifact.equals(artifact)) continue;
                return true;
            }
        }
        return false;
    }

    private static String createFileName(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append('-');
        sb.append(artifact.getArtifactId()).append('-');
        sb.append(artifact.getBaseVersion());
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            sb.append('-').append(classifier);
        }
        sb.append('.').append(artifact.getArtifactHandler().getExtension());
        return sb.toString();
    }

    private static class ArtifactLibraryCoordinates
    implements LibraryCoordinates {
        private final Artifact artifact;

        ArtifactLibraryCoordinates(Artifact artifact) {
            this.artifact = (Artifact)Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        }

        public String getGroupId() {
            return this.artifact.getGroupId();
        }

        public String getArtifactId() {
            return this.artifact.getArtifactId();
        }

        public String getVersion() {
            return this.artifact.getBaseVersion();
        }

        public String toString() {
            return this.artifact.toString();
        }
    }
}

