/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantObject;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnotations;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.FieldGenOrMethodGen;
import org.aspectj.apache.bcel.generic.Type;

public class FieldGen
extends FieldGenOrMethodGen {
    private Object value = null;

    public FieldGen(int access_flags, Type type, String name, ConstantPool cp) {
        this.setModifiers(access_flags);
        this.setType(type);
        this.setName(name);
        this.setConstantPool(cp);
    }

    public FieldGen(Field field, ConstantPool cp) {
        this(field.getModifiers(), Type.getType(field.getSignature()), field.getName(), cp);
        Attribute[] attrs = field.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i] instanceof ConstantValue) {
                this.setValue(((ConstantValue)attrs[i]).getConstantValueIndex());
            } else if (attrs[i] instanceof RuntimeAnnotations) {
                RuntimeAnnotations runtimeAnnotations = (RuntimeAnnotations)attrs[i];
                List l = runtimeAnnotations.getAnnotations();
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    AnnotationGen element = (AnnotationGen)it.next();
                    this.addAnnotation(new AnnotationGen(element, cp, false));
                }
            } else {
                this.addAttribute(attrs[i]);
            }
            ++i;
        }
    }

    private void setValue(int index) {
        ConstantPool cp = this.cp;
        Constant c = cp.getConstant(index);
        this.value = ((ConstantObject)((Object)c)).getConstantValue(cp);
    }

    public void wipeValue() {
        this.value = null;
    }

    private void checkType(Type atype) {
        if (this.type == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!this.type.equals(atype)) {
            throw new ClassGenException("Types are not compatible: " + this.type + " vs. " + atype);
        }
    }

    public Field getField() {
        String signature = this.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        if (this.value != null) {
            this.checkType(this.type);
            int index = this.addConstant();
            this.addAttribute(new ConstantValue(this.cp.addUtf8("ConstantValue"), 2, index, this.cp));
        }
        this.addAnnotationsAsAttribute(this.cp);
        return new Field(this.modifiers, name_index, signature_index, this.getAttributesImmutable(), this.cp);
    }

    private int addConstant() {
        switch (this.type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return this.cp.addInteger((Integer)this.value);
            }
            case 6: {
                return this.cp.addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return this.cp.addDouble((Double)this.value);
            }
            case 11: {
                return this.cp.addLong((Long)this.value);
            }
            case 14: {
                return this.cp.addString((String)this.value);
            }
        }
        throw new RuntimeException("Oops: Unhandled : " + this.type.getType());
    }

    public String getSignature() {
        return this.type.getSignature();
    }

    public String getInitialValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(this.modifiers);
        access = access.equals("") ? "" : String.valueOf(access) + " ";
        String signature = this.type.toString();
        String name = this.getName();
        StringBuffer buf = new StringBuffer(String.valueOf(access) + signature + " " + name);
        String value = this.getInitialValue();
        if (value != null) {
            buf.append(" = " + value);
        }
        return buf.toString();
    }

    public FieldGen copy(ConstantPool cp) {
        FieldGen fg = (FieldGen)this.clone();
        fg.setConstantPool(cp);
        return fg;
    }
}

