/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriSet
implements Iterable<URI> {
    private final Map<String, URI> URIs;

    public UriSet(URI ... URIs) {
        this(Arrays.asList(URIs));
    }

    public UriSet(Collection<URI> URIs) {
        this.URIs = new HashMap<String, URI>();
        for (URI location : URIs) {
            this.URIs.put(location.toASCIIString(), location);
        }
    }

    private UriSet(Map<String, URI> URIs) {
        this.URIs = URIs;
    }

    public UriSet include(String pattern) {
        return this.filter(Filters.patterns(pattern));
    }

    public UriSet include(UriSet URISet) {
        HashMap<String, URI> URIs = new HashMap<String, URI>(this.URIs);
        URIs.putAll(URISet.URIs);
        return new UriSet(URIs);
    }

    public UriSet include(URI URI2) {
        HashMap<String, URI> URIs = new HashMap<String, URI>(this.URIs);
        URIs.put(URI2.toASCIIString(), URI2);
        return new UriSet(URIs);
    }

    public UriSet exclude(UriSet URISet) {
        HashMap<String, URI> URIs = new HashMap<String, URI>(this.URIs);
        Map<String, URI> parentURIs = URISet.URIs;
        for (String URI2 : parentURIs.keySet()) {
            URIs.remove(URI2);
        }
        return new UriSet(URIs);
    }

    public UriSet exclude(URI URI2) {
        HashMap<String, URI> URIs = new HashMap<String, URI>(this.URIs);
        URIs.remove(URI2.toASCIIString());
        return new UriSet(URIs);
    }

    public UriSet exclude(File file) {
        return this.exclude(this.relative(file));
    }

    public UriSet exclude(String pattern) {
        return this.filter(Filters.invert(Filters.patterns(pattern)));
    }

    public UriSet excludePaths(String pathString) {
        String[] paths = pathString.split(File.pathSeparator);
        UriSet URISet = this;
        for (String path : paths) {
            File file = new File(path);
            URISet = URISet.exclude(file);
        }
        return URISet;
    }

    public UriSet filter(Filter filter) {
        HashMap<String, URI> URIs = new HashMap<String, URI>();
        for (Map.Entry<String, URI> entry : this.URIs.entrySet()) {
            String URI2 = entry.getKey();
            if (!filter.accept(URI2)) continue;
            URIs.put(URI2, entry.getValue());
        }
        return new UriSet(URIs);
    }

    public UriSet matching(String pattern) {
        return this.filter(Filters.patterns(pattern));
    }

    public UriSet relative(File file) {
        String URIPath = file.toURI().toASCIIString();
        HashMap<String, URI> URIs = new HashMap<String, URI>();
        for (Map.Entry<String, URI> entry : this.URIs.entrySet()) {
            String URI2 = entry.getKey();
            if (!URI2.startsWith(URIPath) && !URI2.startsWith("jar:" + URIPath)) continue;
            URIs.put(URI2, entry.getValue());
        }
        return new UriSet(URIs);
    }

    public List<URI> getURIs() {
        return new ArrayList<URI>(this.URIs.values());
    }

    public int size() {
        return this.URIs.size();
    }

    @Override
    public Iterator<URI> iterator() {
        return this.getURIs().iterator();
    }

    public String toString() {
        return super.toString() + "[" + this.URIs.size() + "]";
    }
}

