/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMSerializer;
import org.apache.axiom.om.impl.util.OMSerializerUtil;

public class StreamingOMSerializer
implements XMLStreamConstants,
OMSerializer {
    private static int namespaceSuffix = 0;
    public static final String NAMESPACE_PREFIX = "ns";
    private int depth = 0;

    public void serialize(XMLStreamReader node, XMLStreamWriter writer) throws XMLStreamException {
        this.serializeNode(node, writer);
    }

    protected void serializeNode(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                this.serializeElement(reader, writer);
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader, writer);
            } else if (event == 4) {
                this.serializeText(reader, writer);
            } else if (event == 5) {
                this.serializeComment(reader, writer);
            } else if (event == 12) {
                this.serializeCData(reader, writer);
            } else if (event == 2) {
                this.serializeEndElement(writer);
                --this.depth;
            } else if (event == 7) {
                ++this.depth;
            } else if (event == 8) {
                if (this.depth != 0) {
                    --this.depth;
                }
                try {
                    this.serializeEndElement(writer);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.depth != 0) continue;
            break;
        }
    }

    protected void serializeElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String writerPrefix;
        String namespace;
        String prefix;
        int i;
        ArrayList<String> writePrefixList = null;
        ArrayList<String> writeNSList = null;
        String ePrefix = reader.getPrefix();
        ePrefix = ePrefix != null && ePrefix.length() == 0 ? null : ePrefix;
        String eNamespace = reader.getNamespaceURI();
        eNamespace = eNamespace != null && eNamespace.length() == 0 ? null : eNamespace;
        boolean setPrefixFirst = OMSerializerUtil.isSetPrefixBeforeStartElement(writer);
        if (!setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    writer.writeStartElement("", reader.getLocalName(), eNamespace);
                } else {
                    writer.writeStartElement(ePrefix, reader.getLocalName(), eNamespace);
                }
            } else {
                writer.writeStartElement(reader.getLocalName());
            }
        }
        int count = reader.getNamespaceCount();
        for (int i2 = 0; i2 < count; ++i2) {
            String prefix2 = reader.getNamespacePrefix(i2);
            prefix2 = prefix2 != null && prefix2.length() == 0 ? null : prefix2;
            String namespace2 = reader.getNamespaceURI(i2);
            String newPrefix = OMSerializerUtil.generateSetPrefix(prefix2, namespace2 = namespace2 != null && namespace2.length() == 0 ? null : namespace2, writer, false);
            if (newPrefix == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace2);
        }
        String newPrefix = OMSerializerUtil.generateSetPrefix(ePrefix, eNamespace, writer, false);
        if (newPrefix != null) {
            if (writePrefixList == null) {
                writePrefixList = new ArrayList<String>();
                writeNSList = new ArrayList<String>();
            }
            if (!writePrefixList.contains(newPrefix)) {
                writePrefixList.add(newPrefix);
                writeNSList.add(eNamespace);
            }
        }
        count = reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            prefix = reader.getAttributePrefix(i);
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            namespace = reader.getAttributeNamespace(i);
            String string = namespace = namespace != null && namespace.length() == 0 ? null : namespace;
            if (prefix == null && namespace != null) {
                writerPrefix = writer.getPrefix(namespace);
                writerPrefix = writerPrefix != null && writerPrefix.length() == 0 ? null : writerPrefix;
                String string2 = prefix = writerPrefix != null ? writerPrefix : this.generateUniquePrefix(writer.getNamespaceContext());
            }
            if ((newPrefix = OMSerializerUtil.generateSetPrefix(prefix, namespace, writer, true)) == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace);
        }
        if (setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    writer.writeStartElement("", reader.getLocalName(), eNamespace);
                } else {
                    writer.writeStartElement(ePrefix, reader.getLocalName(), eNamespace);
                }
            } else {
                writer.writeStartElement(reader.getLocalName());
            }
        }
        if (writePrefixList != null) {
            for (i = 0; i < writePrefixList.size(); ++i) {
                prefix = (String)writePrefixList.get(i);
                namespace = (String)writeNSList.get(i);
                if (prefix != null) {
                    writer.writeNamespace(prefix, namespace);
                    continue;
                }
                writer.writeDefaultNamespace(namespace);
            }
        }
        count = reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            prefix = reader.getAttributePrefix(i);
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            namespace = reader.getAttributeNamespace(i);
            String string = namespace = namespace != null && namespace.length() == 0 ? null : namespace;
            if (prefix == null && namespace != null) {
                prefix = writer.getPrefix(namespace);
            } else if (namespace != null && !prefix.equals(writerPrefix = writer.getPrefix(namespace))) {
                prefix = writerPrefix;
            }
            if (namespace != null) {
                writer.writeAttribute(prefix, namespace, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    protected void serializeEndElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    protected void serializeText(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(reader.getText());
    }

    protected void serializeCData(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCData(reader.getText());
    }

    protected void serializeComment(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment(reader.getText());
    }

    protected void serializeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String prefix = null;
        String namespaceName = null;
        String writerPrefix = null;
        for (int i = 0; i < count; ++i) {
            prefix = reader.getAttributePrefix(i);
            namespaceName = reader.getAttributeNamespace(i);
            if (namespaceName == null) {
                namespaceName = "";
            }
            writerPrefix = writer.getNamespaceContext().getPrefix(namespaceName);
            if (!"".equals(namespaceName)) {
                if (writerPrefix != null && (prefix == null || prefix.equals(""))) {
                    writer.writeAttribute(writerPrefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                if (prefix != null && !"".equals(prefix) && !prefix.equals(writerPrefix)) {
                    writer.writeNamespace(prefix, namespaceName);
                    writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                prefix = this.generateUniquePrefix(writer.getNamespaceContext());
                writer.writeNamespace(prefix, namespaceName);
                writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    private String generateUniquePrefix(NamespaceContext nsCtxt) {
        String prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        while (nsCtxt.getNamespaceURI(prefix) != null) {
            prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        }
        return prefix;
    }

    private void serializeNamespace(String prefix, String URI, XMLStreamWriter writer) throws XMLStreamException {
        String prefix1 = writer.getPrefix(URI);
        if (prefix1 == null) {
            writer.writeNamespace(prefix, URI);
            writer.setPrefix(prefix, URI);
        }
    }
}

