/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.guice.GuiceComponentInjector;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;

public class GuiceWebApplicationFactory
implements IWebApplicationFactory {
    public static final String STAGE_PARAMETER = "wicket-guice.stage";

    public WebApplication createApplication(WicketFilter filter) {
        Injector injector;
        String injectorContextAttribute = filter.getFilterConfig().getInitParameter("injectorContextAttribute");
        Stage stage = null;
        String stageContextAttribute = filter.getFilterConfig().getInitParameter(STAGE_PARAMETER);
        if (stageContextAttribute == null) {
            stageContextAttribute = filter.getFilterConfig().getServletContext().getInitParameter(STAGE_PARAMETER);
        }
        if (stageContextAttribute != null) {
            stage = Stage.valueOf((String)stageContextAttribute.trim());
        }
        if (injectorContextAttribute != null) {
            ServletContext sc = filter.getFilterConfig().getServletContext();
            injector = (Injector)sc.getAttribute(injectorContextAttribute);
            if (injector == null) {
                throw new RuntimeException("Could not find Guice Injector in the ServletContext under attribute: " + injectorContextAttribute);
            }
        } else if (filter.getFilterConfig().getInitParameter("module") != null) {
            String paramValue = filter.getFilterConfig().getInitParameter("module");
            String[] moduleNames = paramValue.split(",");
            Module[] modules = new Module[moduleNames.length];
            for (int i = 0; i < moduleNames.length; ++i) {
                String moduleName = moduleNames[i].trim();
                try {
                    Class<?> moduleClazz = Class.forName(moduleName);
                    Object moduleObject = moduleClazz.newInstance();
                    modules[i] = (Module)moduleObject;
                    continue;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Could not create new instance of Guice Module class " + moduleName, e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not create new instance of Guice Module class " + moduleName, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Could not create new instance of Guice Module class " + moduleName, e);
                }
            }
            injector = stage != null ? Guice.createInjector((Stage)stage, (Module[])modules) : Guice.createInjector((Module[])modules);
        } else {
            throw new RuntimeException("To use GuiceWebApplicationFactory, you must specify either an 'injectorContextAttribute' or a 'module' init-param.");
        }
        WebApplication app = (WebApplication)injector.getInstance(WebApplication.class);
        app.addComponentInstantiationListener((IComponentInstantiationListener)new GuiceComponentInjector((Application)app, injector));
        return app;
    }
}

