/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.rating;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class RatingPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference STAR0 = new PackageResourceReference(RatingPanel.class, "star0.gif");
    public static final ResourceReference STAR1 = new PackageResourceReference(RatingPanel.class, "star1.gif");
    private IModel<Integer> nrOfStars = new Model((Serializable)Integer.valueOf(5));
    private final IModel<Integer> nrOfVotes;
    private final IModel<Boolean> hasVoted;
    private Component ratingLabel;
    private final boolean addDefaultCssStyle;

    public RatingPanel(String id) {
        this(id, null, 5, true);
    }

    public RatingPanel(String id, IModel<? extends Number> rating) {
        this(id, rating, (IModel<Integer>)new Model((Serializable)Integer.valueOf(5)), null, (IModel<Boolean>)new Model((Serializable)Boolean.FALSE), true);
    }

    public RatingPanel(String id, int nrOfStars) {
        this(id, null, nrOfStars, true);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, int nrOfStars, boolean addDefaultCssStyle) {
        this(id, rating, (IModel<Integer>)new Model((Serializable)Integer.valueOf(nrOfStars)), null, (IModel<Boolean>)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, int nrOfStars, IModel<Integer> nrOfVotes, boolean addDefaultCssStyle) {
        this(id, rating, (IModel<Integer>)new Model((Serializable)Integer.valueOf(nrOfStars)), nrOfVotes, (IModel<Boolean>)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, IModel<Integer> nrOfStars, IModel<Integer> nrOfVotes, IModel<Boolean> hasVoted, boolean addDefaultCssStyle) {
        super(id, rating);
        this.addDefaultCssStyle = addDefaultCssStyle;
        this.nrOfStars = this.wrap(nrOfStars);
        this.nrOfVotes = this.wrap(nrOfVotes);
        this.hasVoted = this.wrap(hasVoted);
        WebMarkupContainer rater = new WebMarkupContainer("rater");
        rater.add(new Component[]{this.newRatingStarBar("element", this.nrOfStars)});
        this.ratingLabel = this.newRatingLabel("rating", (IModel<? extends Number>)this.wrap(rating), this.nrOfVotes);
        rater.add(new Component[]{this.ratingLabel});
        rater.setOutputMarkupId(true);
        this.add(new Component[]{rater});
        this.setRenderBodyOnly(true);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.addDefaultCssStyle) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(RatingPanel.class, "RatingPanel.css")));
        }
    }

    protected Component newRatingStarBar(String id, IModel<Integer> nrOfStars) {
        return new RatingStarBar(id, nrOfStars);
    }

    protected Component newRatingLabel(String id, IModel<? extends Number> rating, IModel<Integer> nrOfVotes) {
        StringResourceModel model;
        if (nrOfVotes == null) {
            Object[] parameters = new Object[]{rating};
            model = new StringResourceModel("rating.simple", (Component)this, null, parameters);
        } else {
            Object[] parameters = new Object[]{rating, nrOfVotes};
            model = new StringResourceModel("rating.complete", (Component)this, null, parameters);
        }
        return new Label(id, (IModel)model);
    }

    protected String getActiveStarUrl(int iteration) {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(STAR1);
        return this.getRequestCycle().urlFor((IRequestHandler)handler).toString();
    }

    protected String getInactiveStarUrl(int iteration) {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(STAR0);
        return this.getRequestCycle().urlFor((IRequestHandler)handler).toString();
    }

    public RatingPanel setRatingLabelVisible(boolean visible) {
        this.ratingLabel.setVisible(visible);
        return this;
    }

    protected abstract boolean onIsStarActive(int var1);

    protected abstract void onRated(int var1, AjaxRequestTarget var2);

    private final class RatingStarBar
    extends Loop {
        private static final long serialVersionUID = 1L;

        private RatingStarBar(String id, IModel<Integer> model) {
            super(id, model);
        }

        protected void populateItem(LoopItem item) {
            AjaxFallbackLink<Void> link = new AjaxFallbackLink<Void>("link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    LoopItem item = (LoopItem)this.getParent();
                    RatingPanel.this.onRated(item.getIndex() + 1, target);
                    if (target != null) {
                        target.add(new Component[]{RatingPanel.this.get("rater")});
                    }
                }

                public boolean isEnabled() {
                    return (Boolean)RatingPanel.this.hasVoted.getObject() == false;
                }
            };
            int iteration = item.getIndex();
            link.add(new Component[]{new WebMarkupContainer("star").add(new Behavior[]{AttributeModifier.replace((String)"src", (Serializable)((Object)(RatingPanel.this.onIsStarActive(iteration) ? RatingPanel.this.getActiveStarUrl(iteration) : RatingPanel.this.getInactiveStarUrl(iteration))))})});
            item.add(new Component[]{link});
        }
    }
}

