/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterStateModel;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;

public class FilterForm<T>
extends Form<T> {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new JavaScriptResourceReference(FilterForm.class, "wicket-filterform.js");
    private final IFilterStateLocator<T> locator;

    public FilterForm(String id, IFilterStateLocator<T> locator) {
        super(id, new FilterStateModel<T>(locator));
        this.locator = locator;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("Wicket.FilterForm.restore('%s');", this.getFocusTrackerFieldCssId())));
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        super.onComponentTagBody(markupStream, openTag);
        String id = Strings.escapeMarkup((CharSequence)this.getFocusTrackerFieldCssId()).toString();
        String value = this.getRequest().getPostParameters().getParameterValue(id).toString("");
        this.getResponse().write((CharSequence)String.format("<div style='position: absolute; left: -9999px; width: 1px; height: 1px;'><input type='hidden' name='%s' id='%s' value='%s'/><input type='submit'/></div>", id, id, value));
    }

    public final String getFocusTrackerFieldCssId() {
        return this.getMarkupId() + "focus";
    }

    public final IFilterStateLocator<T> getStateLocator() {
        return this.locator;
    }

    public final void enableFocusTracking(FormComponent<?> fc) {
        fc.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void bind(Component component) {
                super.bind(component);
                component.setOutputMarkupId(true);
            }

            public void onComponentTag(Component component, ComponentTag tag) {
                tag.put("onfocus", (CharSequence)FilterForm.this.getFocusTrackingHandler(component));
                super.onComponentTag(component, tag);
            }
        }});
    }

    public final String getFocusTrackingHandler(Component component) {
        return String.format("Wicket.FilterForm.focused(this, '%s');", this.getFocusTrackerFieldCssId());
    }
}

