/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.AbstractDataExporter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;

public class CSVDataExporter
extends AbstractDataExporter {
    private char delimiter = (char)44;
    private String characterSet = "utf-8";
    private char quoteCharacter = (char)34;
    private boolean exportHeadersEnabled = true;

    public CSVDataExporter() {
        super((IModel<String>)Model.of((Serializable)((Object)"CSV")), "text/csv", "csv");
    }

    public CSVDataExporter setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public CSVDataExporter setCharacterSet(String characterSet) {
        this.characterSet = (String)Args.notNull((Object)characterSet, (String)"characterSer");
        return this;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public CSVDataExporter setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
        return this;
    }

    @Override
    public String getContentType() {
        return super.getContentType() + "; charset=" + this.characterSet + "; header=" + (this.exportHeadersEnabled ? "present" : "absent");
    }

    public CSVDataExporter setExportHeadersEnabled(boolean exportHeadersEnabled) {
        this.exportHeadersEnabled = exportHeadersEnabled;
        return this;
    }

    public boolean isExportHeadersEnabled() {
        return this.exportHeadersEnabled;
    }

    protected String quoteValue(String value) {
        return this.quoteCharacter + value.replace("" + this.quoteCharacter, "" + this.quoteCharacter + this.quoteCharacter) + this.quoteCharacter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void exportData(IDataProvider<T> dataProvider, List<IExportableColumn<T, ?>> columns, OutputStream outputStream) throws IOException {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(outputStream, Charset.forName(this.characterSet)));){
            if (this.isExportHeadersEnabled()) {
                boolean first = true;
                for (IExportableColumn<T, ?> col : columns) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(this.delimiter);
                    }
                    out.print(this.quoteValue((String)col.getDisplayModel().getObject()));
                }
                out.print("\r\n");
            }
            long numberOfRows = dataProvider.size();
            Iterator rowIterator = dataProvider.iterator(0L, numberOfRows);
            while (rowIterator.hasNext()) {
                Object row = rowIterator.next();
                boolean first = true;
                for (IExportableColumn<T, ?> col : columns) {
                    Object o;
                    if (first) {
                        first = false;
                    } else {
                        out.print(this.delimiter);
                    }
                    if ((o = col.getDataModel(dataProvider.model(row)).getObject()) == null) continue;
                    Class<?> c = o.getClass();
                    IConverter converter = Application.get().getConverterLocator().getConverter(c);
                    String s = converter == null ? o.toString() : converter.convertToString(o, Session.get().getLocale());
                    out.print(this.quoteValue(s));
                }
                out.print("\r\n");
            }
        }
    }
}

