/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.image.resource;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.response.ByteArrayResponse;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ThumbnailImageResource.class);
    private final IResource unscaledImageResource;
    private final int maxSize;
    private transient byte[] thumbnail;

    public ThumbnailImageResource(IResource unscaledImageResource, int maxSize) {
        if (unscaledImageResource == null) {
            throw new IllegalArgumentException("Argument unscaledImageResource must be not null");
        }
        this.unscaledImageResource = unscaledImageResource;
        this.maxSize = maxSize;
    }

    protected byte[] getImageData(IResource.Attributes attributes) {
        if (this.thumbnail == null) {
            BufferedImage image = this.getScaledImageInstance(attributes);
            this.thumbnail = this.toImageData(image);
            this.setLastModifiedTime(Time.now());
        }
        return this.thumbnail;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final BufferedImage getScaledImageInstance(IResource.Attributes attributes) {
        int newHeight;
        int newWidth;
        ByteArrayInputStream is = null;
        BufferedImage originalImage = null;
        try {
            ByteArrayResponse byteResponse = new ByteArrayResponse();
            IResource.Attributes dispatchAttributes = new IResource.Attributes(attributes.getRequest(), (Response)byteResponse);
            this.unscaledImageResource.respond(dispatchAttributes);
            is = new ByteArrayInputStream(byteResponse.getBytes());
            originalImage = ImageIO.read(is);
            if (originalImage == null) {
                throw new IOException("Unable to read unscaled image");
            }
        }
        catch (IOException e) {
            try {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.close(is);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            IOUtils.close((Closeable)is);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int originalWidth = originalImage.getWidth();
        int originalHeight = originalImage.getHeight();
        if (originalWidth <= this.maxSize) {
            if (originalHeight <= this.maxSize) return originalImage;
        }
        if (originalWidth > originalHeight) {
            newWidth = this.maxSize;
            newHeight = this.maxSize * originalHeight / originalWidth;
        } else {
            newWidth = this.maxSize * originalWidth / originalHeight;
            newHeight = this.maxSize;
        }
        BufferedImage dimg = new BufferedImage(newWidth, newHeight, originalImage.getType());
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(originalImage, 0, 0, newWidth, newHeight, 0, 0, originalWidth, originalHeight, null);
        g.dispose();
        return dimg;
    }
}

