/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.MultipartRequest;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadInfo;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.upload.FileUploadException;

public class UploadWebRequest
extends ServletWebRequest {
    final HttpServletRequest req;
    private static final String SESSION_KEY = UploadWebRequest.class.getName();

    public UploadWebRequest(HttpServletRequest req) {
        super(req);
        this.req = req;
    }

    public WebRequest newMultipartWebRequest(Bytes maxsize) {
        try {
            MultipartRequest multipartRequest = new MultipartRequest(this.req, maxsize);
            multipartRequest.setRequestParameters(this.getRequestParameters());
            return multipartRequest;
        }
        catch (FileUploadException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    static UploadInfo getUploadInfo(HttpServletRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("req cannot be null");
        }
        return (UploadInfo)req.getSession().getAttribute(SESSION_KEY);
    }

    static void setUploadInfo(HttpServletRequest req, UploadInfo uploadInfo) {
        if (req == null) {
            throw new IllegalArgumentException("req cannot be null");
        }
        if (uploadInfo == null) {
            throw new IllegalArgumentException("uploadInfo cannot be null");
        }
        req.getSession().setAttribute(SESSION_KEY, (Object)uploadInfo);
    }

    static void clearUploadInfo(HttpServletRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("req cannot be null");
        }
        req.getSession().removeAttribute(SESSION_KEY);
    }
}

