/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.DummyLock;
import org.apache.tapestry5.ioc.internal.util.JDKUtils;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerthreadManagerImpl
implements PerthreadManager {
    private final Lock lock;
    private final PerThreadValue<List<ThreadCleanupListener>> listenersValue;
    private final Logger logger;
    private final MapHolder holder = new MapHolder();
    private final AtomicInteger uuidGenerator = new AtomicInteger();
    private static Object NULL_VALUE = new Object();

    public PerthreadManagerImpl(Logger logger) {
        this(logger, JDKUtils.JDK_1_5);
    }

    PerthreadManagerImpl(Logger logger, boolean useSynchronization) {
        this.logger = logger;
        this.lock = useSynchronization ? new ReentrantLock() : new DummyLock();
        this.listenersValue = this.createValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getPerthreadMap() {
        try {
            this.lock.lock();
            Map map = (Map)this.holder.get();
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<ThreadCleanupListener> getListeners() {
        List<ThreadCleanupListener> result = this.listenersValue.get();
        if (result == null) {
            result = CollectionFactory.newList();
            this.listenersValue.set(result);
        }
        return result;
    }

    @Override
    public void addThreadCleanupListener(ThreadCleanupListener listener) {
        this.getListeners().add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        List<ThreadCleanupListener> listeners = this.getListeners();
        this.listenersValue.set(null);
        for (ThreadCleanupListener listener : listeners) {
            try {
                listener.threadDidCleanup();
            }
            catch (Exception ex) {
                this.logger.warn(ServiceMessages.threadCleanupError(listener, ex), (Throwable)ex);
            }
        }
        try {
            this.lock.lock();
            this.holder.remove();
        }
        finally {
            this.lock.unlock();
        }
    }

    <T> PerThreadValue<T> createValue(final Object key) {
        return new PerThreadValue<T>(){

            @Override
            public T get() {
                return this.get(null);
            }

            @Override
            public T get(T defaultValue) {
                Map map = PerthreadManagerImpl.this.getPerthreadMap();
                if (map.containsKey(key)) {
                    Object storedValue = map.get(key);
                    if (storedValue == NULL_VALUE) {
                        return null;
                    }
                    return storedValue;
                }
                return defaultValue;
            }

            @Override
            public T set(T newValue) {
                PerthreadManagerImpl.this.getPerthreadMap().put(key, newValue == null ? NULL_VALUE : newValue);
                return newValue;
            }

            @Override
            public boolean exists() {
                return PerthreadManagerImpl.this.getPerthreadMap().containsKey(key);
            }
        };
    }

    @Override
    public <T> PerThreadValue<T> createValue() {
        return this.createValue(this.uuidGenerator.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Runnable runnable) {
        assert (runnable != null);
        try {
            runnable.run();
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(Invokable<T> invokable) {
        try {
            T t = invokable.invoke();
            return t;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapHolder
    extends ThreadLocal<Map> {
        private MapHolder() {
        }

        @Override
        protected Map initialValue() {
            return CollectionFactory.newMap();
        }
    }
}

