/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.internal.AbstractServiceCreator;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class ConstructorServiceCreator
extends AbstractServiceCreator {
    private final Constructor constructor;

    public ConstructorServiceCreator(ServiceBuilderResources resources, String creatorDescription, Constructor constructor) {
        super(resources, creatorDescription);
        this.constructor = constructor;
    }

    public String toString() {
        return this.creatorDescription;
    }

    public Object createObject() {
        return this.resources.getTracker().invoke("Invoking " + this.creatorDescription, new Invokable<Object>(){

            @Override
            public Object invoke() {
                Throwable failure = null;
                Object result = null;
                InternalUtils.validateConstructorForAutobuild(ConstructorServiceCreator.this.constructor);
                InjectionResources injectionResources = ConstructorServiceCreator.this.createInjectionResources();
                try {
                    Object[] parameters = InternalUtils.calculateParametersForConstructor(ConstructorServiceCreator.this.constructor, ConstructorServiceCreator.this.resources, injectionResources, ConstructorServiceCreator.this.resources.getTracker());
                    if (ConstructorServiceCreator.this.logger.isDebugEnabled()) {
                        ConstructorServiceCreator.this.logger.debug(IOCMessages.invokingConstructor(ConstructorServiceCreator.this.creatorDescription));
                    }
                    result = ConstructorServiceCreator.this.constructor.newInstance(parameters);
                    InternalUtils.injectIntoFields(result, ConstructorServiceCreator.this.resources, injectionResources, ConstructorServiceCreator.this.resources.getTracker());
                }
                catch (InvocationTargetException ite) {
                    failure = ite.getTargetException();
                }
                catch (Exception ex) {
                    failure = ex;
                }
                if (failure != null) {
                    throw new RuntimeException(IOCMessages.constructorError(ConstructorServiceCreator.this.creatorDescription, ConstructorServiceCreator.this.serviceId, failure), failure);
                }
                InternalUtils.invokePostInjectionMethods(result, ConstructorServiceCreator.this.resources, injectionResources, ConstructorServiceCreator.this.resources.getTracker());
                return result;
            }
        });
    }
}

