/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtils {
    public static Class extractGenericReturnType(Class containingClassType, Method method) {
        return GenericsUtils.extractActualTypeAsClass(containingClassType, method.getDeclaringClass(), method.getGenericReturnType(), method.getReturnType());
    }

    public static Class extractGenericFieldType(Class containingClassType, Field field) {
        return GenericsUtils.extractActualTypeAsClass(containingClassType, field.getDeclaringClass(), field.getGenericType(), field.getType());
    }

    public static Type extractActualType(Type owner, Field field) {
        return GenericsUtils.extractActualType(owner, field.getDeclaringClass(), field.getGenericType(), field.getType());
    }

    public static Type extractActualType(Type owner, Method method) {
        return GenericsUtils.extractActualType(owner, method.getDeclaringClass(), method.getGenericReturnType(), method.getReturnType());
    }

    private static Type extractActualType(Type containingType, Class declaringClass, Type type, Class defaultType) {
        if (type instanceof ParameterizedType) {
            return type;
        }
        if (!(type instanceof TypeVariable)) {
            return defaultType;
        }
        TypeVariable typeVariable = (TypeVariable)type;
        if (!declaringClass.isAssignableFrom(GenericsUtils.asClass(containingType))) {
            throw new RuntimeException(String.format("%s must be a subclass of %s", declaringClass.getName(), GenericsUtils.asClass(containingType).getName()));
        }
        Type extractedType = type;
        if (containingType instanceof ParameterizedType) {
            int i = GenericsUtils.getTypeVariableIndex(GenericsUtils.asClass(containingType), typeVariable);
            extractedType = ((ParameterizedType)((Object)containingType)).getActualTypeArguments()[i];
            if (extractedType instanceof Class || extractedType instanceof ParameterizedType) {
                return extractedType;
            }
        }
        LinkedList classStack = new LinkedList();
        Class cur = containingType;
        while (cur != null && !GenericsUtils.asClass(cur).equals(declaringClass)) {
            classStack.add(0, cur);
            cur = GenericsUtils.asClass(cur).getSuperclass();
        }
        int typeArgumentIndex = GenericsUtils.getTypeVariableIndex(declaringClass, (TypeVariable)extractedType);
        for (Type type2 : classStack) {
            Class descendantClass = GenericsUtils.asClass(type2);
            ParameterizedType parameterizedType = (ParameterizedType)descendantClass.getGenericSuperclass();
            extractedType = parameterizedType.getActualTypeArguments()[typeArgumentIndex];
            if (extractedType instanceof Class || extractedType instanceof ParameterizedType) {
                return extractedType;
            }
            if (!(extractedType instanceof TypeVariable)) break;
            typeArgumentIndex = GenericsUtils.getTypeVariableIndex(descendantClass, (TypeVariable)extractedType);
        }
        return defaultType;
    }

    private static Class extractActualTypeAsClass(Class containingClassType, Class<?> declaringClass, Type type, Class<?> defaultType) {
        Type actualType = GenericsUtils.extractActualType(containingClassType, declaringClass, type, defaultType);
        return GenericsUtils.asClass(actualType);
    }

    public static Class asClass(Type actualType) {
        Type rawType;
        if (actualType instanceof ParameterizedType && (rawType = ((ParameterizedType)actualType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return (Class)actualType;
    }

    private static int getTypeVariableIndex(Class clazz, TypeVariable typeVar) {
        int typeArgumentIndex;
        String typeVarName = typeVar.getName();
        TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
        for (typeArgumentIndex = 0; typeArgumentIndex < typeParameters.length && !typeParameters[typeArgumentIndex].getName().equals(typeVarName); ++typeArgumentIndex) {
        }
        return typeArgumentIndex;
    }
}

