/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.services.CachingObjectCreator;
import org.apache.tapestry5.ioc.services.ParallelExecutor;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.ThunkCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelExecutorImpl
implements ParallelExecutor {
    private final ThunkCreator thunkCreator;
    private final ExecutorService executorService;
    private final PerthreadManager perthreadManager;

    public ParallelExecutorImpl(ExecutorService executorService, ThunkCreator thunkCreator, PerthreadManager perthreadManager) {
        this.executorService = executorService;
        this.thunkCreator = thunkCreator;
        this.perthreadManager = perthreadManager;
    }

    @Override
    public <T> Future<T> invoke(Invokable<T> invocable) {
        assert (invocable != null);
        return this.executorService.submit(this.toCallable(invocable));
    }

    private <T> Callable<T> toCallable(final Invokable<T> invocable) {
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                try {
                    Object t = invocable.invoke();
                    return t;
                }
                finally {
                    ParallelExecutorImpl.this.perthreadManager.cleanup();
                }
            }
        };
    }

    @Override
    public <T> T invoke(Class<T> proxyType, Invokable<T> invocable) {
        final Future<T> future = this.invoke(invocable);
        ObjectCreator creator = new ObjectCreator(){

            public Object createObject() {
                try {
                    return future.get();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        String description = String.format("FutureThunk[%s]", proxyType.getName());
        return this.thunkCreator.createThunk(proxyType, new CachingObjectCreator(creator), description);
    }
}

