/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Map;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.internal.AbstractConfigurationImpl;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.MappedConfigurationOverride;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingMappedConfigurationWrapper<K, V>
extends AbstractConfigurationImpl<V>
implements MappedConfiguration<K, V> {
    private final Map<K, V> map;
    private final Map<K, MappedConfigurationOverride<K, V>> overrides;
    private final String serviceId;
    private final ContributionDef contributionDef;
    private final Class<K> expectedKeyType;
    private final Class<V> expectedValueType;
    private final Map<K, ContributionDef> keyToContributor;

    public ValidatingMappedConfigurationWrapper(Class<V> expectedValueType, ObjectLocator locator, Map<K, V> map, Map<K, MappedConfigurationOverride<K, V>> overrides, String serviceId, ContributionDef contributionDef, Class<K> expectedKeyType, Map<K, ContributionDef> keyToContributor) {
        super(expectedValueType, locator);
        this.map = map;
        this.overrides = overrides;
        this.serviceId = serviceId;
        this.contributionDef = contributionDef;
        this.expectedKeyType = expectedKeyType;
        this.expectedValueType = expectedValueType;
        this.keyToContributor = keyToContributor;
    }

    @Override
    public void add(K key, V value) {
        this.validateKey(key);
        if (value == null) {
            throw new NullPointerException(IOCMessages.contributionWasNull(this.serviceId));
        }
        this.validateValue(value);
        ContributionDef existing = this.keyToContributor.get(key);
        if (existing != null) {
            throw new IllegalArgumentException(IOCMessages.contributionDuplicateKey(this.serviceId, existing));
        }
        this.map.put(key, value);
        this.keyToContributor.put(key, this.contributionDef);
    }

    private void validateValue(V value) {
        if (!this.expectedValueType.isInstance(value)) {
            throw new IllegalArgumentException(IOCMessages.contributionWrongValueType(this.serviceId, value.getClass(), this.expectedValueType));
        }
    }

    private void validateKey(K key) {
        if (key == null) {
            throw new NullPointerException(IOCMessages.contributionKeyWasNull(this.serviceId));
        }
        if (!this.expectedKeyType.isInstance(key)) {
            throw new IllegalArgumentException(IOCMessages.contributionWrongKeyType(this.serviceId, key.getClass(), this.expectedKeyType));
        }
    }

    @Override
    public void addInstance(K key, Class<? extends V> clazz) {
        this.add(key, this.instantiate(clazz));
    }

    @Override
    public void override(K key, V value) {
        MappedConfigurationOverride<K, V> existing;
        this.validateKey(key);
        if (value != null) {
            this.validateValue(value);
        }
        if ((existing = this.overrides.get(key)) != null) {
            throw new IllegalArgumentException(String.format("Contribution key %s has already been overridden (by %s).", key, existing.getContribDef()));
        }
        this.overrides.put(key, new MappedConfigurationOverride<K, V>(this.contributionDef, this.map, key, value));
    }

    @Override
    public void overrideInstance(K key, Class<? extends V> clazz) {
        this.override(key, this.instantiate(clazz));
    }
}

