/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ServiceActivity;
import org.apache.tapestry5.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry5.ioc.services.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceActivityTrackerImpl
implements ServiceActivityScoreboard,
ServiceActivityTracker {
    private final Map<String, MutableServiceActivity> serviceIdToServiceStatus = new TreeMap<String, MutableServiceActivity>();

    @Override
    public synchronized List<ServiceActivity> getServiceActivity() {
        List<ServiceActivity> result = CollectionFactory.newList();
        result.addAll(this.serviceIdToServiceStatus.values());
        return result;
    }

    void startup() {
    }

    void shutdown() {
    }

    @Override
    public synchronized void define(ServiceDef serviceDef, Status initialStatus) {
        this.serviceIdToServiceStatus.put(serviceDef.getServiceId(), new MutableServiceActivity(serviceDef, initialStatus));
    }

    @Override
    public synchronized void setStatus(String serviceId, Status status) {
        this.serviceIdToServiceStatus.get(serviceId).setStatus(status);
    }

    public static class MutableServiceActivity
    implements ServiceActivity {
        private final ServiceDef serviceDef;
        private Status status;

        public MutableServiceActivity(ServiceDef serviceDef, Status status) {
            this.serviceDef = serviceDef;
            this.status = status;
        }

        public String getServiceId() {
            return this.serviceDef.getServiceId();
        }

        public Class getServiceInterface() {
            return this.serviceDef.getServiceInterface();
        }

        public String getScope() {
            return this.serviceDef.getServiceScope();
        }

        public synchronized Status getStatus() {
            return this.status;
        }

        synchronized void setStatus(Status status) {
            this.status = status;
        }
    }
}

