/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.services;

import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.Coercion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoercionTuple<S, T> {
    private final Class<S> sourceType;
    private final Class<T> targetType;
    private final Coercion<S, T> coercion;

    private String convert(Class type) {
        if (Void.TYPE.equals(type)) {
            return "null";
        }
        String name = ClassFabUtils.toJavaClassName(type);
        int dotx = name.lastIndexOf(46);
        if (dotx > 0 && name.substring(0, dotx).equals("java.lang")) {
            return name.substring(dotx + 1);
        }
        return name;
    }

    public CoercionTuple(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        this(sourceType, targetType, coercion, true);
    }

    public static <S, T> CoercionTuple<S, T> create(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        return new CoercionTuple<S, T>(sourceType, targetType, coercion);
    }

    public CoercionTuple(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion, boolean wrap) {
        assert (sourceType != null);
        assert (targetType != null);
        assert (coercion != null);
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.coercion = wrap ? new CoercionWrapper(coercion) : coercion;
    }

    public String toString() {
        return this.coercion.toString();
    }

    public Coercion<S, T> getCoercion() {
        return this.coercion;
    }

    public Class<S> getSourceType() {
        return this.sourceType;
    }

    public Class<T> getTargetType() {
        return this.targetType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CoercionWrapper<WS, WT>
    implements Coercion<WS, WT> {
        private final Coercion<WS, WT> coercion;

        public CoercionWrapper(Coercion<WS, WT> coercion) {
            this.coercion = coercion;
        }

        @Override
        public WT coerce(WS input) {
            return this.coercion.coerce(input);
        }

        public String toString() {
            return String.format("%s --> %s", CoercionTuple.this.convert(CoercionTuple.this.sourceType), CoercionTuple.this.convert(CoercionTuple.this.targetType));
        }
    }
}

