/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.services;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassFabUtils {
    private static final AtomicLong UID_GENERATOR = new AtomicLong(System.currentTimeMillis());
    private static final Map<String, PrimitiveInfo> PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO = CollectionFactory.newMap();
    private static final Map<Class, PrimitiveInfo> WRAPPER_TYPE_TO_PRIMITIVE_INFO = CollectionFactory.newMap();

    public static String nextUID() {
        return Long.toHexString(UID_GENERATOR.getAndIncrement());
    }

    public static synchronized String generateClassName(String baseName) {
        return "$" + baseName + "_" + ClassFabUtils.nextUID();
    }

    public static String generateClassName(Class interfaceClass) {
        return ClassFabUtils.generateClassName(interfaceClass.getSimpleName());
    }

    public static String toJavaClassName(Class inputClass) {
        if (inputClass.isArray()) {
            return ClassFabUtils.toJavaClassName(inputClass.getComponentType()) + "[]";
        }
        return inputClass.getName();
    }

    public static boolean isToString(Method method) {
        if (!method.getName().equals("toString")) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        return method.getReturnType().equals(String.class);
    }

    public static Class getPrimitiveType(String primitiveTypeName) {
        return PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.get(primitiveTypeName).primitiveType;
    }

    private static void add(Class primitiveType, String typeCode, Class wrapperType, String unwrapMethod) {
        PrimitiveInfo info = new PrimitiveInfo(primitiveType, typeCode, wrapperType, unwrapMethod);
        PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.put(primitiveType.getName(), info);
        WRAPPER_TYPE_TO_PRIMITIVE_INFO.put(wrapperType, info);
    }

    public static String toJVMBinaryName(String type) {
        if (!type.endsWith("[]")) {
            return type;
        }
        StringBuilder buffer = new StringBuilder();
        while (type.endsWith("[]")) {
            buffer.append("[");
            type = type.substring(0, type.length() - 2);
        }
        PrimitiveInfo pi = PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.get(type);
        if (pi != null) {
            buffer.append(pi.typeCode);
        } else {
            buffer.append("L");
            buffer.append(type);
            buffer.append(";");
        }
        return buffer.toString();
    }

    public static Class getPrimitiveType(Class wrapperType) {
        return WRAPPER_TYPE_TO_PRIMITIVE_INFO.get(wrapperType).primitiveType;
    }

    public static Class getWrapperType(Class type) {
        PrimitiveInfo info = PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.get(type.getName());
        return info == null ? type : info.wrapperType;
    }

    public static String castReference(String reference, String desiredType) {
        if (ClassFabUtils.isPrimitiveType(desiredType)) {
            PrimitiveInfo info = PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.get(desiredType);
            return String.format("((%s)%s).%s()", info.wrapperType.getName(), reference, info.unwrapMethod);
        }
        return String.format("(%s)%s", desiredType, reference);
    }

    public static String getUnwrapMethodName(Class primitiveType) {
        return PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.get(primitiveType.getName()).unwrapMethod;
    }

    public static boolean isPrimitiveType(String typeName) {
        return PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.containsKey(typeName);
    }

    public static String getTypeCode(Class type) {
        if (type.equals(Void.TYPE)) {
            return "V";
        }
        if (type.isPrimitive()) {
            return PRIMITIVE_TYPE_NAME_TO_PRIMITIVE_INFO.get(type.getName()).typeCode;
        }
        if (type.isArray()) {
            return "[" + ClassFabUtils.getTypeCode(type.getComponentType());
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    public static <T> T createObjectCreatorProxy(ClassFab classFab, Class<T> serviceInterface, ObjectCreator creator, String description) {
        classFab.addField("_creator", 18, ObjectCreator.class);
        classFab.addConstructor(new Class[]{ObjectCreator.class}, null, "_creator = $1;");
        String body = String.format("return (%s) _creator.createObject();", serviceInterface.getName());
        MethodSignature sig = new MethodSignature(serviceInterface, "_delegate", null, null);
        classFab.addMethod(2, sig, body);
        classFab.proxyMethodsToDelegate(serviceInterface, "_delegate()", description);
        Class proxyClass = classFab.createClass();
        try {
            Object proxy = proxyClass.getConstructors()[0].newInstance(creator);
            return serviceInterface.cast(proxy);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static String getPathForClass(Class clazz) {
        assert (clazz != null);
        return ClassFabUtils.getPathForClassNamed(clazz.getName());
    }

    public static String getPathForClassNamed(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static File toFileFromFileProtocolURL(URL url) {
        assert (url != null);
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException(String.format("URL %s does not use the 'file' protocol.", url));
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }

    static {
        ClassFabUtils.add(Boolean.TYPE, "Z", Boolean.class, "booleanValue");
        ClassFabUtils.add(Short.TYPE, "S", Short.class, "shortValue");
        ClassFabUtils.add(Integer.TYPE, "I", Integer.class, "intValue");
        ClassFabUtils.add(Long.TYPE, "J", Long.class, "longValue");
        ClassFabUtils.add(Float.TYPE, "F", Float.class, "floatValue");
        ClassFabUtils.add(Double.TYPE, "D", Double.class, "doubleValue");
        ClassFabUtils.add(Character.TYPE, "C", Character.class, "charValue");
        ClassFabUtils.add(Byte.TYPE, "B", Byte.class, "byteValue");
    }

    private static class PrimitiveInfo {
        private final Class primitiveType;
        private final String typeCode;
        private final Class wrapperType;
        private final String unwrapMethod;

        public PrimitiveInfo(Class primitiveType, String typeCode, Class wrapperType, String unwrapMethod) {
            this.primitiveType = primitiveType;
            this.typeCode = typeCode;
            this.wrapperType = wrapperType;
            this.unwrapMethod = unwrapMethod;
        }
    }
}

