/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.services.PropertyAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAdapterImpl
implements PropertyAdapter {
    private final String _name;
    private final Method _readMethod;
    private final Method _writeMethod;
    private final Class _type;

    public PropertyAdapterImpl(String name, Class type, Method readMethod, Method writeMethod) {
        this._name = Defense.notBlank(name, "name");
        this._type = Defense.notNull(type, "type");
        this._readMethod = readMethod;
        this._writeMethod = writeMethod;
    }

    public PropertyAdapterImpl(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Method getReadMethod() {
        return this._readMethod;
    }

    @Override
    public Class getType() {
        return this._type;
    }

    @Override
    public Method getWriteMethod() {
        return this._writeMethod;
    }

    @Override
    public boolean isRead() {
        return this._readMethod != null;
    }

    @Override
    public boolean isUpdate() {
        return this._writeMethod != null;
    }

    @Override
    public Object get(Object instance) {
        Throwable fail;
        if (this._readMethod == null) {
            throw new UnsupportedOperationException(ServiceMessages.readNotSupported(instance, this._name));
        }
        try {
            return this._readMethod.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        throw new RuntimeException(ServiceMessages.readFailure(this._name, instance, fail), fail);
    }

    @Override
    public void set(Object instance, Object value) {
        Throwable fail;
        if (this._writeMethod == null) {
            throw new UnsupportedOperationException(ServiceMessages.writeNotSupported(instance, this._name));
        }
        try {
            this._writeMethod.invoke(instance, value);
            return;
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        throw new RuntimeException(ServiceMessages.writeFailure(this._name, instance, fail), fail);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T result;
        T t = result = this._readMethod != null ? (T)this._readMethod.getAnnotation(annotationClass) : null;
        if (result == null && this._writeMethod != null) {
            result = this._writeMethod.getAnnotation(annotationClass);
        }
        return result;
    }
}

