/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ioc.internal.services.ExceptionAnalysisImpl;
import org.apache.tapestry.ioc.internal.services.ExceptionInfoImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry.ioc.services.ExceptionAnalysis;
import org.apache.tapestry.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry.ioc.services.ExceptionInfo;
import org.apache.tapestry.ioc.services.PropertyAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionAnalyzerImpl
implements ExceptionAnalyzer {
    private final PropertyAccess _propertyAccess;
    private final Set<String> _throwableProperties;

    public ExceptionAnalyzerImpl(PropertyAccess propertyAccess) {
        this._propertyAccess = propertyAccess;
        this._throwableProperties = CollectionFactory.newSet(this._propertyAccess.getAdapter(Throwable.class).getPropertyNames());
    }

    @Override
    public ExceptionAnalysis analyze(Throwable rootException) {
        List<ExceptionInfo> list = CollectionFactory.newList();
        ExceptionInfo previousInfo = null;
        for (Throwable t = rootException; t != null; t = t.getCause()) {
            ExceptionInfo info = this.extractInfo(t);
            if (!this.addsValue(previousInfo, info)) continue;
            list.add(info);
            previousInfo = info;
        }
        return new ExceptionAnalysisImpl(list);
    }

    private boolean addsValue(ExceptionInfo previousInfo, ExceptionInfo info) {
        if (previousInfo == null) {
            return true;
        }
        if (!info.getStackTrace().isEmpty()) {
            return true;
        }
        if (!previousInfo.getMessage().contains(info.getMessage())) {
            return true;
        }
        for (String name : info.getPropertyNames()) {
            if (info.getProperty(name).equals(previousInfo.getProperty(name))) continue;
            return true;
        }
        return false;
    }

    private ExceptionInfo extractInfo(Throwable t) {
        Map<String, Object> properties = CollectionFactory.newMap();
        ClassPropertyAdapter adapter = this._propertyAccess.getAdapter(t);
        for (String name : adapter.getPropertyNames()) {
            Object value;
            if (this._throwableProperties.contains(name) || (value = adapter.get(t, name)) == null) continue;
            properties.put(name, value);
        }
        List<String> stackTrace = Collections.emptyList();
        if (t.getCause() == null) {
            stackTrace = this.extractStackTrace(t);
        }
        return new ExceptionInfoImpl(t, properties, stackTrace);
    }

    private List<String> extractStackTrace(Throwable t) {
        List<String> trace = CollectionFactory.newList();
        for (StackTraceElement e : t.getStackTrace()) {
            if (e.getClassName().startsWith("$") && e.getLineNumber() < 0) continue;
            trace.add(e.toString());
        }
        return trace;
    }
}

