/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingConfigurationWrapper<T>
implements Configuration<T> {
    private final String _serviceId;
    private final ContributionDef _contributionDef;
    private final Logger _logger;
    private final Configuration<T> _delegate;
    private final Class _expectedType;

    public ValidatingConfigurationWrapper(String serviceId, Logger logger, Class expectedType, ContributionDef contributionDef, Configuration<T> delegate) {
        this._serviceId = serviceId;
        this._logger = logger;
        this._expectedType = expectedType;
        this._contributionDef = contributionDef;
        this._delegate = delegate;
    }

    @Override
    public void add(T object) {
        if (object == null) {
            this._logger.warn(IOCMessages.contributionWasNull(this._serviceId, this._contributionDef));
            return;
        }
        if (!this._expectedType.isInstance(object)) {
            this._logger.warn(IOCMessages.contributionWrongValueType(this._serviceId, this._contributionDef, object.getClass(), this._expectedType));
            return;
        }
        this._delegate.add(object);
    }
}

