/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ioc.AnnotationProvider;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.LoggerSource;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.ModuleBuilderSource;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ObjectLocator;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.ServiceDecorator;
import org.apache.tapestry.ioc.ServiceLifecycle;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.InternalRegistry;
import org.apache.tapestry.ioc.internal.Module;
import org.apache.tapestry.ioc.internal.ModuleImpl;
import org.apache.tapestry.ioc.internal.NullAnnotationProvider;
import org.apache.tapestry.ioc.internal.SerializationSupport;
import org.apache.tapestry.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry.ioc.internal.ServiceActivityTrackerImpl;
import org.apache.tapestry.ioc.internal.ServiceProxyProvider;
import org.apache.tapestry.ioc.internal.ServiceResourcesImpl;
import org.apache.tapestry.ioc.internal.SingletonServiceLifecycle;
import org.apache.tapestry.ioc.internal.ValidatingConfigurationWrapper;
import org.apache.tapestry.ioc.internal.ValidatingMappedConfigurationWrapper;
import org.apache.tapestry.ioc.internal.ValidatingOrderedConfigurationWrapper;
import org.apache.tapestry.ioc.internal.services.RegistryShutdownHubImpl;
import org.apache.tapestry.ioc.internal.services.ThreadCleanupHubImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.internal.util.Orderer;
import org.apache.tapestry.ioc.services.Builtin;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.RegistryShutdownHub;
import org.apache.tapestry.ioc.services.RegistryShutdownListener;
import org.apache.tapestry.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry.ioc.services.ServiceLifecycleSource;
import org.apache.tapestry.ioc.services.Status;
import org.apache.tapestry.ioc.services.SymbolSource;
import org.apache.tapestry.ioc.services.TapestryIOCModule;
import org.apache.tapestry.ioc.services.ThreadCleanupHub;
import org.apache.tapestry.services.MasterObjectProvider;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryImpl
implements Registry,
InternalRegistry,
ServiceProxyProvider {
    private static final String SYMBOL_SOURCE_SERVICE_ID = "SymbolSource";
    private static final String REGISTRY_SHUTDOWN_HUB_SERVICE_ID = "RegistryShutdownHub";
    static final String THREAD_CLEANUP_HUB_SERVICE_ID = "ThreadCleanupHub";
    private static final String SERVICE_ACTIVITY_SCOREBOARD_SERVICE_ID = "ServiceActivityScoreboard";
    private static final Set<Class> BUILTIN = CollectionFactory.newSet();
    static final String CLASS_FACTORY_SERVICE_ID = "ClassFactory";
    static final String LOGGER_SOURCE_SERVICE_ID = "LoggerSource";
    private final OneShotLock _lock = new OneShotLock();
    private final OneShotLock _eagerLoadLock = new OneShotLock();
    private final Map<String, Object> _builtinServices = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, Class> _builtinTypes = CollectionFactory.newCaseInsensitiveMap();
    private final RegistryShutdownHubImpl _registryShutdownHub;
    private final LoggerSource _loggerSource;
    private final Map<String, Module> _serviceIdToModule = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, ServiceLifecycle> _lifecycles = CollectionFactory.newCaseInsensitiveMap();
    private final ThreadCleanupHubImpl _cleanupHub;
    private final ClassFactory _classFactory;
    private final ServiceActivityTracker _tracker;
    private SymbolSource _symbolSource;
    private final List<Module> _modules = CollectionFactory.newList();
    private final Map<Class, List<ServiceDef>> _markerToServiceDef = CollectionFactory.newMap();

    public RegistryImpl(Collection<ModuleDef> moduleDefs, ClassFactory classFactory, LoggerSource loggerSource) {
        this._loggerSource = loggerSource;
        final ServiceActivityTrackerImpl scoreboardAndTracker = new ServiceActivityTrackerImpl();
        this._tracker = scoreboardAndTracker;
        this.addBuiltin(SERVICE_ACTIVITY_SCOREBOARD_SERVICE_ID, ServiceActivityScoreboard.class, scoreboardAndTracker);
        this.addBuiltin(LOGGER_SOURCE_SERVICE_ID, LoggerSource.class, this._loggerSource);
        this._classFactory = classFactory;
        this.addBuiltin(CLASS_FACTORY_SERVICE_ID, ClassFactory.class, this._classFactory);
        Logger logger = this.loggerForBuiltinService(THREAD_CLEANUP_HUB_SERVICE_ID);
        this._cleanupHub = new ThreadCleanupHubImpl(logger);
        this.addBuiltin(THREAD_CLEANUP_HUB_SERVICE_ID, ThreadCleanupHub.class, this._cleanupHub);
        logger = this.loggerForBuiltinService(REGISTRY_SHUTDOWN_HUB_SERVICE_ID);
        this._registryShutdownHub = new RegistryShutdownHubImpl(logger);
        this.addBuiltin(REGISTRY_SHUTDOWN_HUB_SERVICE_ID, RegistryShutdownHub.class, this._registryShutdownHub);
        this._lifecycles.put("singleton", new SingletonServiceLifecycle());
        this._registryShutdownHub.addRegistryShutdownListener(new RegistryShutdownListener(){

            public void registryDidShutdown() {
                scoreboardAndTracker.shutdown();
            }
        });
        for (ModuleDef def : moduleDefs) {
            logger = this._loggerSource.getLogger(def.getLoggerName());
            ModuleImpl module = new ModuleImpl(this, this._tracker, def, classFactory, logger);
            this._modules.add(module);
            for (String serviceId : def.getServiceIds()) {
                ServiceDef serviceDef = module.getServiceDef(serviceId);
                Module existing = this._serviceIdToModule.get(serviceId);
                if (existing != null) {
                    throw new RuntimeException(IOCMessages.serviceIdConflict(serviceId, existing.getServiceDef(serviceId), serviceDef));
                }
                this._serviceIdToModule.put(serviceId, module);
                this._tracker.define(serviceDef, Status.DEFINED);
                for (Class marker : serviceDef.getMarkers()) {
                    InternalUtils.addToMapList(this._markerToServiceDef, marker, serviceDef);
                }
            }
        }
        scoreboardAndTracker.startup();
        SerializationSupport.setProvider(this);
    }

    @Override
    public void performRegistryStartup() {
        this._eagerLoadLock.lock();
        for (Module m : this._modules) {
            m.eagerLoadServices();
        }
        this.getService("RegistryStartup", Runnable.class).run();
        this.cleanupThread();
    }

    @Override
    public Logger getServiceLogger(String serviceId) {
        Module module = this._serviceIdToModule.get(serviceId);
        assert (module != null);
        return this._loggerSource.getLogger(module.getLoggerName() + "." + serviceId);
    }

    private Logger loggerForBuiltinService(String serviceId) {
        return this._loggerSource.getLogger(TapestryIOCModule.class + "." + serviceId);
    }

    private <T> void addBuiltin(final String serviceId, final Class<T> serviceInterface, T service) {
        this._builtinTypes.put(serviceId, serviceInterface);
        this._builtinServices.put(serviceId, service);
        ServiceDef serviceDef = new ServiceDef(){

            @Override
            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                return null;
            }

            @Override
            public Set<Class> getMarkers() {
                return BUILTIN;
            }

            @Override
            public String getServiceId() {
                return serviceId;
            }

            @Override
            public Class getServiceInterface() {
                return serviceInterface;
            }

            @Override
            public String getServiceScope() {
                return "singleton";
            }

            @Override
            public boolean isEagerLoad() {
                return false;
            }
        };
        for (Class marker : serviceDef.getMarkers()) {
            InternalUtils.addToMapList(this._markerToServiceDef, marker, serviceDef);
        }
        this._tracker.define(serviceDef, Status.BUILTIN);
    }

    @Override
    public synchronized void shutdown() {
        this._lock.lock();
        this._registryShutdownHub.fireRegistryDidShutdown();
        SerializationSupport.clearProvider(this);
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface) {
        this._lock.check();
        T result = this.checkForBuiltinService(serviceId, serviceInterface);
        if (result != null) {
            return result;
        }
        Module containingModule = this.locateModuleForService(serviceId);
        return containingModule.getService(serviceId, serviceInterface);
    }

    private <T> T checkForBuiltinService(String serviceId, Class<T> serviceInterface) {
        Object service = this._builtinServices.get(serviceId);
        if (service == null) {
            return null;
        }
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, this._builtinTypes.get(serviceId), serviceInterface));
        }
    }

    @Override
    public void cleanupThread() {
        this._lock.check();
        this._cleanupHub.cleanup();
    }

    private Module locateModuleForService(String serviceId) {
        Module module = this._serviceIdToModule.get(serviceId);
        if (module == null) {
            throw new RuntimeException(IOCMessages.noSuchService(serviceId, this._serviceIdToModule.keySet()));
        }
        return module;
    }

    @Override
    public <T> Collection<T> getUnorderedConfiguration(ServiceDef serviceDef, Class<T> objectType) {
        this._lock.check();
        final List result = CollectionFactory.newList();
        Configuration configuration = new Configuration<T>(){

            @Override
            public void add(T object) {
                result.add(object);
            }
        };
        List<Module> modules = this._modules;
        for (Module m : modules) {
            this.addToUnorderedConfiguration(configuration, objectType, serviceDef, m);
        }
        return result;
    }

    @Override
    public <T> List<T> getOrderedConfiguration(ServiceDef serviceDef, Class<T> objectType) {
        this._lock.check();
        String serviceId = serviceDef.getServiceId();
        Logger logger = this.getServiceLogger(serviceId);
        Orderer orderer = new Orderer(logger);
        OrderedConfigurationToOrdererAdaptor<4> configuration = new OrderedConfigurationToOrdererAdaptor<4>(orderer);
        List<Module> modules = this._modules;
        for (Module m : modules) {
            this.addToOrderedConfiguration(configuration, objectType, serviceDef, m);
        }
        if (serviceId.equals("MasterObjectProvider")) {
            ObjectProvider contribution = new ObjectProvider(){

                @Override
                public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                    return (T)RegistryImpl.this.findServiceByMarkerAndType(objectType, annotationProvider);
                }
            };
            configuration.add("ServiceByMarker", contribution, new String[0]);
        }
        return orderer.getOrdered();
    }

    @Override
    public <K, V> Map<K, V> getMappedConfiguration(ServiceDef serviceDef, Class<K> keyType, Class<V> objectType) {
        this._lock.check();
        final Map<K, V> result = this.newConfigurationMap(keyType);
        Map<K, V> keyToContribution = this.newConfigurationMap(keyType);
        MappedConfiguration configuration = new MappedConfiguration<K, V>(){

            @Override
            public void add(K key, V value) {
                result.put(key, value);
            }
        };
        List<Module> modules = this._modules;
        for (Module m : modules) {
            this.addToMappedConfiguration(configuration, keyToContribution, keyType, objectType, serviceDef, m);
        }
        return result;
    }

    private <K, V> Map<K, V> newConfigurationMap(Class<K> keyType) {
        if (keyType.equals(String.class)) {
            Map result = CollectionFactory.newCaseInsensitiveMap();
            return result;
        }
        return CollectionFactory.newMap();
    }

    private <K, V> void addToMappedConfiguration(MappedConfiguration<K, V> configuration, Map<K, ContributionDef> keyToContribution, Class<K> keyClass, Class<V> valueType, ServiceDef serviceDef, Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef> contributions = module.getContributorDefsForService(serviceId);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        boolean debug = logger.isDebugEnabled();
        ServiceResourcesImpl locator = new ServiceResourcesImpl(this, module, serviceDef, this._classFactory, logger);
        for (ContributionDef def : contributions) {
            ValidatingMappedConfigurationWrapper<K, V> validating = new ValidatingMappedConfigurationWrapper<K, V>(serviceId, def, logger, keyClass, valueType, keyToContribution, configuration);
            if (debug) {
                logger.debug(IOCMessages.invokingMethod(def));
            }
            def.contribute((ModuleBuilderSource)module, (ObjectLocator)locator, validating);
        }
    }

    private <T> void addToUnorderedConfiguration(Configuration<T> configuration, Class<T> valueType, ServiceDef serviceDef, Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef> contributions = module.getContributorDefsForService(serviceId);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        boolean debug = logger.isDebugEnabled();
        ServiceResourcesImpl locator = new ServiceResourcesImpl(this, module, serviceDef, this._classFactory, logger);
        for (ContributionDef def : contributions) {
            ValidatingConfigurationWrapper<T> validating = new ValidatingConfigurationWrapper<T>(serviceId, logger, valueType, def, configuration);
            if (debug) {
                logger.debug(IOCMessages.invokingMethod(def));
            }
            def.contribute((ModuleBuilderSource)module, (ObjectLocator)locator, validating);
        }
    }

    private <T> void addToOrderedConfiguration(OrderedConfiguration<T> configuration, Class<T> valueType, ServiceDef serviceDef, Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef> contributions = module.getContributorDefsForService(serviceId);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        boolean debug = logger.isDebugEnabled();
        ServiceResourcesImpl locator = new ServiceResourcesImpl(this, module, serviceDef, this._classFactory, logger);
        for (ContributionDef def : contributions) {
            ValidatingOrderedConfigurationWrapper<T> validating = new ValidatingOrderedConfigurationWrapper<T>(serviceId, def, logger, valueType, configuration);
            if (debug) {
                logger.debug(IOCMessages.invokingMethod(def));
            }
            def.contribute((ModuleBuilderSource)module, (ObjectLocator)locator, validating);
        }
    }

    @Override
    public <T> T getService(Class<T> serviceInterface) {
        this._lock.check();
        List<String> serviceIds = this.findServiceIdsForInterface(serviceInterface);
        if (serviceIds == null) {
            serviceIds = Collections.emptyList();
        }
        switch (serviceIds.size()) {
            case 0: {
                throw new RuntimeException(IOCMessages.noServiceMatchesType(serviceInterface));
            }
            case 1: {
                String serviceId = serviceIds.get(0);
                return this.getService(serviceId, serviceInterface);
            }
        }
        Collections.sort(serviceIds);
        throw new RuntimeException(IOCMessages.manyServiceMatches(serviceInterface, serviceIds));
    }

    private List<String> findServiceIdsForInterface(Class serviceInterface) {
        List<String> result = CollectionFactory.newList();
        for (Module module : this._modules) {
            result.addAll(module.findServiceIdsForInterface(serviceInterface));
        }
        for (Map.Entry entry : this._builtinServices.entrySet()) {
            if (!serviceInterface.isInstance(entry.getValue())) continue;
            result.add((String)entry.getKey());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public ServiceLifecycle getServiceLifecycle(String scope) {
        this._lock.check();
        ServiceLifecycle result = this._lifecycles.get(scope);
        if (result == null) {
            ServiceLifecycleSource source = this.getService("ServiceLifecycleSource", ServiceLifecycleSource.class);
            result = source.get(scope);
        }
        if (result == null) {
            throw new RuntimeException(IOCMessages.unknownScope(scope));
        }
        return result;
    }

    @Override
    public List<ServiceDecorator> findDecoratorsForService(ServiceDef serviceDef) {
        this._lock.check();
        assert (serviceDef != null);
        Logger logger = this.getServiceLogger(serviceDef.getServiceId());
        Orderer<ServiceDecorator> orderer = new Orderer<ServiceDecorator>(logger);
        for (Module module : this._modules) {
            Set<DecoratorDef> decorators = module.findMatchingDecoratorDefs(serviceDef);
            if (decorators.isEmpty()) continue;
            ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this._classFactory, logger);
            for (DecoratorDef dd : decorators) {
                ServiceDecorator sd = dd.createDecorator(module, resources);
                orderer.add(dd.getDecoratorId(), sd, dd.getConstraints());
            }
        }
        return orderer.getOrdered();
    }

    @Override
    public ClassFab newClass(Class serviceInterface) {
        this._lock.check();
        return this._classFactory.newClass(serviceInterface);
    }

    private <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        this._lock.check();
        AnnotationProvider effectiveProvider = annotationProvider != null ? annotationProvider : new NullAnnotationProvider();
        T result = this.findServiceByMarkerAndType(objectType, annotationProvider);
        if (result != null) {
            return result;
        }
        MasterObjectProvider masterProvider = this.getService("MasterObjectProvider", MasterObjectProvider.class);
        return masterProvider.provide(objectType, effectiveProvider, locator, true);
    }

    private <T> T findServiceByMarkerAndType(Class<T> objectType, AnnotationProvider provider) {
        if (provider == null) {
            return null;
        }
        for (Class marker : this._markerToServiceDef.keySet()) {
            if (provider.getAnnotation(marker) == null) continue;
            List<ServiceDef> matches = CollectionFactory.newList();
            for (ServiceDef def : this._markerToServiceDef.get(marker)) {
                if (!objectType.isAssignableFrom(def.getServiceInterface())) continue;
                matches.add(def);
            }
            switch (matches.size()) {
                case 1: {
                    ServiceDef def = (ServiceDef)matches.get(0);
                    return this.getService(def.getServiceId(), objectType);
                }
                case 0: {
                    throw new RuntimeException(IOCMessages.noServicesMatchMarker(objectType, marker));
                }
            }
            throw new RuntimeException(IOCMessages.manyServicesMatchMarker(objectType, marker, matches));
        }
        return null;
    }

    @Override
    public <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider) {
        this._lock.check();
        return this.getObject(objectType, annotationProvider, this);
    }

    @Override
    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this._lock.check();
        this._registryShutdownHub.addRegistryShutdownListener(listener);
    }

    @Override
    public String expandSymbols(String input) {
        this._lock.check();
        if (!InternalUtils.containsSymbols(input)) {
            return input;
        }
        return this.getSymbolSource().expandSymbols(input);
    }

    private synchronized SymbolSource getSymbolSource() {
        if (this._symbolSource == null) {
            this._symbolSource = this.getService(SYMBOL_SOURCE_SERVICE_ID, SymbolSource.class);
        }
        return this._symbolSource;
    }

    @Override
    public <T> T autobuild(Class<T> clazz) {
        Throwable failure;
        Defense.notNull(clazz, "clazz");
        Constructor constructor = InternalUtils.findAutobuildConstructor(clazz);
        if (constructor == null) {
            throw new RuntimeException(IOCMessages.noAutobuildConstructor(clazz));
        }
        Map<Class, Object> empty = Collections.emptyMap();
        try {
            Object[] parameters = InternalUtils.calculateParametersForConstructor(constructor, this, empty);
            return clazz.cast(constructor.newInstance(parameters));
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        String description = this._classFactory.getConstructorLocation(constructor).toString();
        throw new RuntimeException(IOCMessages.autobuildConstructorError(description, failure), failure);
    }

    @Override
    public <T> T proxy(Class<T> interfaceClass, final Class<? extends T> implementationClass) {
        Defense.notNull(interfaceClass, "interfaceClass");
        Defense.notNull(implementationClass, "implementationClass");
        final ObjectCreator autobuildCreator = new ObjectCreator(){

            public Object createObject() {
                return RegistryImpl.this.autobuild(implementationClass);
            }
        };
        ObjectCreator justInTime = new ObjectCreator(){
            private Object _delegate;

            public synchronized Object createObject() {
                if (this._delegate == null) {
                    this._delegate = autobuildCreator.createObject();
                }
                return this._delegate;
            }
        };
        ClassFab cf = this._classFactory.newClass(interfaceClass);
        String description = String.format("<Autobuild proxy %s(%s)>", implementationClass.getName(), interfaceClass.getName());
        return ClassFabUtils.createObjectCreatorProxy(cf, interfaceClass, justInTime, description);
    }

    @Override
    public Object provideServiceProxy(String serviceId) {
        return this.getService(serviceId, Object.class);
    }

    static {
        BUILTIN.add(Builtin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OrderedConfigurationToOrdererAdaptor<T>
    implements OrderedConfiguration<T> {
        private final Orderer<T> _orderer;

        public OrderedConfigurationToOrdererAdaptor(Orderer<T> orderer) {
            this._orderer = orderer;
        }

        @Override
        public void add(String id, T object, String ... constraints) {
            this._orderer.add(id, object, constraints);
        }
    }
}

