/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import org.apache.tapestry.ioc.internal.MatchType;

public class GlobPatternMatcher {
    private String _substring;
    private MatchType _type;

    public GlobPatternMatcher(String pattern) {
        this.analyze(pattern);
    }

    private void analyze(String pattern) {
        if (pattern.equals("*")) {
            this._type = MatchType.ANY;
            return;
        }
        boolean globPrefix = pattern.startsWith("*");
        boolean globSuffix = pattern.endsWith("*");
        if (globPrefix && globSuffix) {
            this._substring = pattern.substring(1, pattern.length() - 1);
            this._type = MatchType.INFIX;
            return;
        }
        if (globPrefix) {
            this._substring = pattern.substring(1);
            this._type = MatchType.SUFFIX;
            return;
        }
        if (globSuffix) {
            this._substring = pattern.substring(0, pattern.length() - 1);
            this._type = MatchType.PREFIX;
            return;
        }
        this._type = MatchType.EXACT;
        this._substring = pattern;
    }

    public boolean matches(String input) {
        switch (this._type) {
            case ANY: {
                return true;
            }
            case EXACT: {
                return input.equalsIgnoreCase(this._substring);
            }
            case INFIX: {
                return input.toLowerCase().contains(this._substring.toLowerCase());
            }
            case PREFIX: {
                return input.regionMatches(true, 0, this._substring, 0, this._substring.length());
            }
        }
        return input.regionMatches(true, input.length() - this._substring.length(), this._substring, 0, this._substring.length());
    }
}

