/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.func;

import java.util.Collection;
import org.apache.tapestry5.func.ArrayFlow;
import org.apache.tapestry5.func.EmptyFlow;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.LazyContinuation;
import org.apache.tapestry5.func.LazyFlow;
import org.apache.tapestry5.func.LazyFunction;
import org.apache.tapestry5.func.LazyIterate;
import org.apache.tapestry5.func.LazyIterator;
import org.apache.tapestry5.func.LazyRange;
import org.apache.tapestry5.func.LazySeries;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Mapper2;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.func.Reducer;
import org.apache.tapestry5.func.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class F {
    static final Flow<?> EMPTY_FLOW = new EmptyFlow();
    public static Reducer<Integer, Integer> SUM_INTS = new Reducer<Integer, Integer>(){

        @Override
        public Integer reduce(Integer accumulator, Integer value) {
            return accumulator + value;
        }
    };
    public static Mapper2<Integer, Integer, Integer> ADD_INTS = new Mapper2<Integer, Integer, Integer>(){

        @Override
        public Integer map(Integer first, Integer second) {
            return first + second;
        }
    };

    static <T> Flow<T> emptyFlow() {
        return EMPTY_FLOW;
    }

    public static <T> Predicate<T> eql(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T object) {
                return object.equals(value);
            }
        };
    }

    public static Predicate<Number> eq(final long value) {
        return new Predicate<Number>(){

            @Override
            public boolean accept(Number object) {
                return object.longValue() == value;
            }
        };
    }

    public static Predicate<Number> neq(long value) {
        return F.eq(value).invert();
    }

    public static Predicate<Number> gt(final long value) {
        return new Predicate<Number>(){

            @Override
            public boolean accept(Number object) {
                return object.longValue() > value;
            }
        };
    }

    public static Predicate<Number> gteq(long value) {
        return F.eq(value).or(F.gt(value));
    }

    public static Predicate<Number> lt(long value) {
        return F.gteq(value).invert();
    }

    public static Predicate<Number> lteq(long value) {
        return F.gt(value).invert();
    }

    public static <T> Predicate<T> isNull() {
        return new Predicate<T>(){

            @Override
            public boolean accept(T object) {
                return object == null;
            }
        };
    }

    public static <T> Predicate<T> notNull() {
        Predicate<T> isNull = F.isNull();
        return isNull.invert();
    }

    public static <T> Mapper<T, String> stringValueOf() {
        return new Mapper<T, String>(){

            @Override
            public String map(T value) {
                return String.valueOf(value);
            }
        };
    }

    public static <S, T> Mapper<S, T> always(final T fixedResult) {
        return new Mapper<S, T>(){

            @Override
            public T map(S input) {
                return fixedResult;
            }
        };
    }

    public static <S, T> Mapper<S, T> select(final Predicate<? super S> predicate, final Mapper<S, T> ifAccepted, final Mapper<S, T> ifRejected) {
        assert (predicate != null);
        assert (ifAccepted != null);
        assert (ifRejected != null);
        return new Mapper<S, T>(){

            @Override
            public T map(S input) {
                Mapper active = predicate.accept(input) ? ifAccepted : ifRejected;
                return active.map(input);
            }
        };
    }

    public static <S, T> Mapper<S, T> select(Predicate<? super S> predicate, Mapper<S, T> ifAccepted) {
        return F.select(predicate, ifAccepted, (Object)null);
    }

    public static <S, T> Mapper<S, T> select(Predicate<? super S> predicate, Mapper<S, T> ifAccepted, T ifRejectedValue) {
        Mapper<S, T> rejectedMapper = F.always(ifRejectedValue);
        return F.select(predicate, ifAccepted, rejectedMapper);
    }

    public static <S> Mapper<S, S> identity() {
        return new Mapper<S, S>(){

            @Override
            public S map(S input) {
                return input;
            }
        };
    }

    public static <S> Predicate<S> toPredicate(final Mapper<S, Boolean> mapper) {
        assert (mapper != null);
        return new Predicate<S>(){

            @Override
            public boolean accept(S object) {
                return (Boolean)mapper.map(object);
            }
        };
    }

    public static <T> Flow<T> flow(Collection<T> values) {
        assert (values != null);
        if (values.isEmpty()) {
            return F.emptyFlow();
        }
        return new ArrayFlow<T>(values);
    }

    public static <T> Flow<T> flow(T ... values) {
        if (values.length == 0) {
            return F.emptyFlow();
        }
        return new ArrayFlow<T>(values);
    }

    public static <T> Flow<T> flow(Iterable<T> iterable) {
        assert (iterable != null);
        return F.lazy(new LazyIterator<T>(iterable.iterator()));
    }

    public static Flow<Integer> range(int lower, int upper) {
        if (lower == upper) {
            return F.emptyFlow();
        }
        if (lower < upper) {
            return F.lazy(new LazyRange(lower, upper, 1));
        }
        return F.lazy(new LazyRange(lower, upper, -1));
    }

    public static <T> Flow<T> lazy(LazyFunction<T> function) {
        assert (function != null);
        return new LazyFlow<T>(function);
    }

    public static Flow<Integer> series(int start, int delta) {
        return F.lazy(new LazySeries(start, delta));
    }

    public static <T> Flow<T> iterate(final T initial, final Mapper<T, T> mapper) {
        assert (mapper != null);
        return F.lazy(new LazyFunction<T>(){

            @Override
            public LazyContinuation<T> next() {
                return new LazyContinuation<Object>(initial, new LazyIterate<Object>(initial, mapper));
            }
        });
    }

    public static <T> Worker<T> addToCollection(final Collection<T> coll) {
        return new Worker<T>(){

            @Override
            public void work(T value) {
                coll.add(value);
            }
        };
    }
}

