/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;

public final class ProcessEngine {
    public String connect(Grantee grantee, String databaseName) {
        String processId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString().replace("-", "");
        ExecutionGroupContext executionGroupContext = new ExecutionGroupContext(Collections.emptyList(), new ExecutionGroupReportContext(processId, databaseName, grantee));
        Process process = new Process(executionGroupContext);
        ProcessRegistry.getInstance().add(process);
        return executionGroupContext.getReportContext().getProcessId();
    }

    public void disconnect(String processId) {
        ProcessRegistry.getInstance().remove(processId);
    }

    public void executeSQL(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, QueryContext queryContext) {
        if (this.isMySQLDDLOrDMLStatement(queryContext.getSqlStatementContext().getSqlStatement())) {
            ProcessRegistry.getInstance().add(new Process(queryContext.getSql(), executionGroupContext));
        }
    }

    public void completeSQLUnitExecution(SQLExecutionUnit executionUnit, String processId) {
        if (Strings.isNullOrEmpty((String)processId)) {
            return;
        }
        Process process = ProcessRegistry.getInstance().get(processId);
        if (null == process) {
            return;
        }
        process.completeExecutionUnit();
        process.removeProcessStatement(executionUnit.getExecutionUnit());
    }

    public void completeSQLExecution(String processId) {
        if (Strings.isNullOrEmpty((String)processId)) {
            return;
        }
        Process process = ProcessRegistry.getInstance().get(processId);
        if (null == process) {
            return;
        }
        ExecutionGroupContext executionGroupContext = new ExecutionGroupContext(Collections.emptyList(), new ExecutionGroupReportContext(processId, process.getDatabaseName(), new Grantee(process.getUsername(), process.getHostname())));
        ProcessRegistry.getInstance().add(new Process(executionGroupContext));
    }

    private boolean isMySQLDDLOrDMLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLStatement && (sqlStatement instanceof DDLStatement || sqlStatement instanceof DMLStatement);
    }
}

