/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.refresher.type.table;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.connection.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.connection.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class CreateTableStatementSchemaRefresher
implements MetaDataRefresher<CreateTableStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, CreateTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String tableName = TableRefreshUtils.getTableName(databaseType, sqlStatement.getTable().getTableName().getIdentifier());
        RuleMetaData ruleMetaData = new RuleMetaData(new LinkedList(database.getRuleMetaData().getRules()));
        boolean isSingleTable = TableRefreshUtils.isSingleTable(tableName, database);
        if (isSingleTable) {
            ruleMetaData.getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, tableName));
        }
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getProtocolType(), database.getResourceMetaData().getStorageUnits(), ruleMetaData.getRules(), props, schemaName);
        Map schemaMap = GenericSchemaBuilder.build(Collections.singletonList(tableName), (GenericSchemaBuilderMaterial)material);
        Optional<ShardingSphereTable> actualTableMetaData = Optional.ofNullable((ShardingSphereSchema)schemaMap.get(schemaName)).map(optional -> optional.getTable(tableName));
        if (actualTableMetaData.isPresent()) {
            AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName, logicDataSourceNames);
            alterSchemaMetaDataPOJO.getAlteredTables().add(actualTableMetaData.get());
            modeContextManager.alterSchemaMetaData(alterSchemaMetaDataPOJO);
            if (isSingleTable && TableRefreshUtils.isRuleRefreshRequired(ruleMetaData, schemaName, tableName)) {
                modeContextManager.alterSingleRuleConfiguration(database.getName(), ruleMetaData.getConfigurations());
            }
        }
    }

    @Override
    public Class<CreateTableStatement> getType() {
        return CreateTableStatement.class;
    }
}

