/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.test.htmlunit;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class AbstractHtmlUnitTestCase
extends TestCase {
    protected HtmlPage page = null;
    protected URL url = null;
    protected WebClient webClient = null;

    public AbstractHtmlUnitTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        String url = System.getProperty("url");
        this.url = new URL(url + "/");
        this.webClient = new WebClient();
    }

    public static Test suite() {
        return new TestSuite(AbstractHtmlUnitTestCase.class);
    }

    protected void tearDown() throws Exception {
        this.page = null;
        this.url = null;
        this.webClient = null;
    }

    protected HtmlBody body() throws Exception {
        DomNode.DescendantElementsIterator elements = this.page.getAllHtmlChildElements();
        while (elements.hasNext()) {
            HtmlElement element = (HtmlElement)elements.next();
            if (!(element instanceof HtmlBody)) continue;
            return (HtmlBody)element;
        }
        return null;
    }

    protected HtmlElement element(String id) throws Exception {
        try {
            return this.page.getHtmlElementById(id);
        }
        catch (ElementNotFoundException e) {
            return null;
        }
    }

    protected HtmlForm form(String id) throws Exception {
        Iterator forms = this.page.getForms().iterator();
        while (forms.hasNext()) {
            HtmlForm form = (HtmlForm)forms.next();
            if (!id.equals(form.getAttributeValue("id"))) continue;
            return form;
        }
        return null;
    }

    protected HtmlHead head() throws Exception {
        DomNode.DescendantElementsIterator elements = this.page.getAllHtmlChildElements();
        while (elements.hasNext()) {
            HtmlElement element = (HtmlElement)elements.next();
            if (!(element instanceof HtmlHead)) continue;
            return (HtmlHead)element;
        }
        return null;
    }

    protected HtmlPage link(HtmlAnchor anchor) throws IOException {
        HtmlPage page;
        this.page = page = (HtmlPage)anchor.click();
        return page;
    }

    protected HtmlPage page() {
        return this.page;
    }

    protected HtmlPage page(String path) throws Exception {
        HtmlPage page;
        this.page = page = (HtmlPage)this.webClient.getPage(this.url(path));
        return page;
    }

    protected void reset(HtmlPage page) {
        this.page = page;
    }

    protected HtmlPage submit(HtmlSubmitInput submit) throws IOException {
        HtmlPage page;
        this.page = page = (HtmlPage)submit.click();
        return page;
    }

    protected String title() throws Exception {
        return this.page.getTitleText().trim();
    }

    protected URL url(String path) throws Exception {
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Context path '" + path + "' does not start with '/'");
        }
        return new URL(this.url, path.substring(1));
    }
}

