/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.draw;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hwmf.usermodel.HwmfPicture;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.Units;

public class HwmfImageRenderer
implements ImageRenderer {
    HwmfPicture image;
    double alpha;

    public boolean canRender(String contentType) {
        return PictureData.PictureType.WMF.contentType.equalsIgnoreCase(contentType);
    }

    public void loadImage(InputStream data, String contentType) throws IOException {
        if (!PictureData.PictureType.WMF.contentType.equals(contentType)) {
            throw new IOException("Invalid picture type");
        }
        this.image = new HwmfPicture(data);
    }

    public void loadImage(byte[] data, String contentType) throws IOException {
        if (!PictureData.PictureType.WMF.contentType.equals(contentType)) {
            throw new IOException("Invalid picture type");
        }
        this.image = new HwmfPicture(new ByteArrayInputStream(data));
    }

    public Dimension getDimension() {
        int width = 0;
        int height = 0;
        if (this.image != null) {
            Dimension dim = this.image.getSize();
            width = Units.pointsToPixel((double)dim.getWidth());
            height = Units.pointsToPixel((double)dim.getHeight());
        }
        return new Dimension(width, height);
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public BufferedImage getImage() {
        return this.getImage(this.getDimension());
    }

    public BufferedImage getImage(Dimension dim) {
        if (this.image == null) {
            return new BufferedImage(1, 1, 2);
        }
        BufferedImage bufImg = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), 2);
        Graphics2D g = bufImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.image.draw(g, new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight()));
        g.dispose();
        if (this.alpha != 0.0) {
            BufferedImage newImg = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), 2);
            g = newImg.createGraphics();
            RescaleOp op = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, (float)this.alpha}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
            g.drawImage(bufImg, op, 0, 0);
            g.dispose();
            bufImg = newImg;
        }
        return bufImg;
    }

    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor) {
        return this.drawImage(graphics, anchor, null);
    }

    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor, Insets clip) {
        if (this.image == null) {
            return false;
        }
        this.image.draw(graphics, anchor);
        return true;
    }
}

