/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class SoundData
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected SoundData() {
        this._data = new byte[0];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected SoundData(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public byte[] getData() {
        return this._data;
    }

    public long getRecordType() {
        return RecordTypes.SoundData.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }
}

