/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xdgf.usermodel;

import java.lang.reflect.Constructor;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLFactory;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xdgf.usermodel.XDGFDocument;
import org.apache.poi.xdgf.usermodel.XDGFRelation;

public class XDGFFactory
extends POIXMLFactory {
    private static final POILogger logger = POILogFactory.getLogger(XDGFFactory.class);
    private XDGFDocument _document;

    public XDGFFactory(XDGFDocument document) {
        this._document = document;
    }

    @Override
    public POIXMLDocumentPart createDocumentPart(POIXMLDocumentPart parent, PackageRelationship rel, PackagePart part) {
        XDGFRelation descriptor = XDGFRelation.getInstance(rel.getRelationshipType());
        if (descriptor == null || descriptor.getRelationClass() == null) {
            logger.log(1, new Object[]{"using default POIXMLDocumentPart for " + rel.getRelationshipType()});
            return new POIXMLDocumentPart(part, rel);
        }
        try {
            Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
            try {
                Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(POIXMLDocumentPart.class, PackagePart.class, PackageRelationship.class, XDGFDocument.class);
                return constructor.newInstance(parent, part, rel, this._document);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(PackagePart.class, PackageRelationship.class, XDGFDocument.class);
                return constructor.newInstance(part, rel, this._document);
            }
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    @Override
    public POIXMLDocumentPart newDocumentPart(POIXMLRelation descriptor) {
        try {
            Class<? extends POIXMLDocumentPart> cls = descriptor.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = cls.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }
}

