/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.Properties;
import org.apache.openejb.client.RequestType;
import org.apache.openejb.loader.IO;

public class Stop {
    private static final String helpBase = "META-INF/org.apache.openejb.cli/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String host, int port) {
        Socket socket = null;
        OutputStream out = null;
        try {
            socket = new Socket(host, port);
            out = socket.getOutputStream();
            out.write(RequestType.STOP_REQUEST_Stop.getCode());
        }
        catch (ConnectException e) {
            System.out.println(":: server not running ::");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (Throwable e) {}
            }
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public void stop() {
        Stop.stop("localhost", 4200);
    }

    public static void main(String[] args) {
        try {
            String host = "localhost";
            int port = 4200;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    if (args.length <= i + 1) continue;
                    host = args[++i];
                    continue;
                }
                if (args[i].equals("-p")) {
                    if (args.length <= i + 1) continue;
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("--help")) {
                    Stop.printHelp();
                    return;
                }
                if (!args[i].equals("-examples")) continue;
                Stop.printExamples();
                return;
            }
            Stop.stop(host, port);
        }
        catch (Exception re) {
            System.err.println("[EJB Server] FATAL ERROR: " + re.getMessage());
            re.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printHelp() {
        String header = "OpenEJB Remote Server ";
        try {
            Properties versionInfo = Stop.loadVersionProperties();
            header = header + versionInfo.get("version");
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println(header);
        InputStream in = null;
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("META-INF/org.apache.openejb.cli/stop.help");
            if (resource != null) {
                in = resource.openConnection().getInputStream();
                int b = in.read();
                while (b != -1) {
                    System.out.write(b);
                    b = in.read();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printExamples() {
        String header = "OpenEJB Remote Server ";
        try {
            Properties versionInfo = Stop.loadVersionProperties();
            header = header + versionInfo.get("version");
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println(header);
        InputStream in = null;
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("META-INF/org.apache.openejb.cli/stop.examples");
            if (resource != null) {
                in = resource.openConnection().getInputStream();
                int b = in.read();
                while (b != -1) {
                    System.out.write(b);
                    b = in.read();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private static Properties loadVersionProperties() throws IOException {
        return IO.readProperties((URL)new URL("resource:/openejb-version.properties"));
    }
}

