/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.MDC;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.server.DiscoveryRegistry;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceManager;
import org.apache.xbean.finder.ResourceFinder;

public class SimpleServiceManager
extends ServiceManager {
    private ServerService[] daemons;
    private boolean stop = false;

    public void init() throws Exception {
        try {
            MDC.put((String)"SERVER", (Object)"main");
            InetAddress localhost = InetAddress.getLocalHost();
            MDC.put((String)"HOST", (Object)localhost.getHostName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        DiscoveryRegistry registry = new DiscoveryRegistry();
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb");
            jmxName.set("type", "Server");
            jmxName.set("name", "DiscoveryRegistry");
            ObjectName objectName = jmxName.build();
            server.registerMBean(new ManagedMBean((Object)registry), objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", (Throwable)e);
        }
        SystemInstance.get().setComponent(DiscoveryRegistry.class, (Object)registry);
        ServiceFinder serviceFinder = new ServiceFinder("META-INF/");
        Map availableServices = serviceFinder.mapAvailableServices(ServerService.class);
        List<ServerService> enabledServers = this.initServers(availableServices);
        this.daemons = enabledServers.toArray(new ServerService[0]);
    }

    public synchronized void start(boolean block) throws ServiceException {
        boolean display;
        boolean bl = display = System.getProperty("openejb.nobanner") == null;
        if (display) {
            System.out.println("  ** Starting Services **");
            this.printRow("NAME", "IP", "PORT");
        }
        for (int i = 0; i < this.daemons.length; ++i) {
            ServerService d = this.daemons[i];
            try {
                d.start();
                if (!display || d.getPort() == -1) continue;
                this.printRow(d.getName(), d.getIP(), d.getPort() + "");
                continue;
            }
            catch (Exception e) {
                logger.fatal("Service Start Failed: " + d.getName() + " " + d.getIP() + " " + d.getPort() + ": " + e.getMessage());
                if (!display) continue;
                this.printRow(d.getName(), "----", "FAILED");
            }
        }
        if (display) {
            System.out.println("-------");
            System.out.println("Ready!");
        }
        if (!block) {
            return;
        }
        try {
            while (!this.stop) {
                this.wait(Long.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            logger.fatal("Unable to keep the server thread alive. Received exception: " + t.getClass().getName() + " : " + t.getMessage());
        }
        logger.info("Stopping Remote Server");
    }

    public synchronized void stop() throws ServiceException {
        logger.info("Stopping server services");
        this.stop = true;
        for (int i = 0; i < this.daemons.length; ++i) {
            try {
                this.daemons[i].stop();
                continue;
            }
            catch (ServiceException e) {
                logger.fatal("Service Shutdown Failed: " + this.daemons[i].getName() + ".  Exception: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        this.notifyAll();
    }

    private void printRow(String col1, String col2, String col3) {
        col1 = col1 + "                    ";
        col1 = col1.substring(0, 20);
        col2 = col2 + "                    ";
        col2 = col2.substring(0, 15);
        col3 = col3 + "                    ";
        col3 = col3.substring(0, 6);
        StringBuffer sb = new StringBuffer(50);
        sb.append("  ").append(col1);
        sb.append(" ").append(col2);
        sb.append(" ").append(col3);
        System.out.println(sb.toString());
    }

    public static class ServiceFinder {
        private final ResourceFinder resourceFinder;
        private ClassLoader classLoader;

        public ServiceFinder(String basePath) {
            this(basePath, Thread.currentThread().getContextClassLoader());
        }

        public ServiceFinder(String basePath, ClassLoader classLoader) {
            this.resourceFinder = new ResourceFinder(basePath, classLoader);
            this.classLoader = classLoader;
        }

        public Map mapAvailableServices(Class interfase) throws IOException, ClassNotFoundException {
            Map services = this.resourceFinder.mapAvailableProperties(ServerService.class.getName());
            for (Map.Entry entry : services.entrySet()) {
                String name = (String)entry.getKey();
                Properties properties = (Properties)entry.getValue();
                String className = properties.getProperty("className");
                if (className == null && (className = properties.getProperty("classname")) == null) {
                    className = properties.getProperty("server");
                }
                Class<?> impl = this.classLoader.loadClass(className);
                properties.put(interfase, impl);
                String rawProperties = this.resourceFinder.findString(interfase.getName() + "/" + name);
                properties.put(Properties.class, rawProperties);
            }
            return services;
        }
    }
}

