/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;
import org.hsqldb.persist.TableSpaceManagerSimple;
import org.hsqldb.persist.TextCache;

public class DataSpaceManagerSimple
implements DataSpaceManager {
    DataFileCache cache;
    TableSpaceManager defaultSpaceManager;
    int fileBlockSize = 4096;
    long totalFragmentSize;
    int spaceIdSequence = 8;
    DoubleIntIndex lookup;

    DataSpaceManagerSimple(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        if (dataFileCache instanceof DataFileCacheSession) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else if (dataFileCache instanceof TextCache) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(dataFileCache);
        } else {
            int n = dataFileCache.database.logger.propMaxFreeBlocks;
            this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, n, dataFileCache.dataFileScale);
            this.initialiseSpaces();
            dataFileCache.spaceManagerPosition = 0L;
        }
        this.totalFragmentSize = dataFileCache.lostSpaceSize;
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    @Override
    public TableSpaceManager getTableSpace(int n) {
        if (n >= this.spaceIdSequence) {
            this.spaceIdSequence = n + 1;
        }
        return this.defaultSpaceManager;
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence++;
    }

    @Override
    public long getFileBlocks(int n, int n2) {
        long l = this.cache.enlargeFileSpace((long)n2 * (long)this.fileBlockSize);
        return l;
    }

    @Override
    public void freeTableSpace(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(DoubleIntIndex doubleIntIndex, long l, long l2, boolean bl) {
        this.totalFragmentSize += doubleIntIndex.getTotalValues();
        if (bl) {
            if (this.cache.fileFreePosition == l2) {
                this.cache.writeLock.lock();
                try {
                    this.cache.fileFreePosition = l;
                }
                finally {
                    this.cache.writeLock.unlock();
                }
            } else {
                this.totalFragmentSize += l2 - l;
            }
            if (doubleIntIndex.size() != 0) {
                this.lookup = new DoubleIntIndex(doubleIntIndex.size(), true);
                doubleIntIndex.copyTo(this.lookup);
            }
        } else {
            DataSpaceManagerSimple.compactLookup(doubleIntIndex, this.cache.dataFileScale);
            doubleIntIndex.setValuesSearchTarget();
            doubleIntIndex.sort();
            int n = doubleIntIndex.size() - doubleIntIndex.capacity() / 2;
            if (n > 0) {
                doubleIntIndex.removeRange(0, n);
                this.totalFragmentSize -= doubleIntIndex.getTotalValues();
            }
        }
    }

    @Override
    public long getLostBlocksSize() {
        return this.totalFragmentSize + this.defaultSpaceManager.getLostBlocksSize();
    }

    @Override
    public int getFileBlockSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        long l = this.cache.getFileFreePos();
        long l2 = (l + (long)this.fileBlockSize) / (long)this.fileBlockSize;
        long l3 = this.cache.enlargeFileSpace(l2 * (long)this.fileBlockSize - l);
        this.defaultSpaceManager.initialiseFileBlock(this.lookup, l3, this.cache.getFileFreePos());
        if (this.lookup != null) {
            this.totalFragmentSize -= this.lookup.getTotalValues();
            this.lookup = null;
        }
    }

    @Override
    public void reset() {
        this.defaultSpaceManager.reset();
    }

    @Override
    public boolean isMultiSpace() {
        return false;
    }

    static boolean compactLookup(DoubleIntIndex doubleIntIndex, int n) {
        int n2;
        doubleIntIndex.setKeysSearchTarget();
        doubleIntIndex.sort();
        if (doubleIntIndex.size() == 0) {
            return false;
        }
        int[] nArray = doubleIntIndex.getKeys();
        int[] nArray2 = doubleIntIndex.getValues();
        int n3 = 0;
        for (n2 = 1; n2 < doubleIntIndex.size(); ++n2) {
            int n4 = nArray[n3];
            int n5 = nArray2[n3];
            if (n4 + n5 / n == nArray[n2]) {
                int n6 = n3;
                nArray2[n6] = nArray2[n6] + nArray2[n2];
                continue;
            }
            if (++n3 == n2) continue;
            nArray[n3] = nArray[n2];
            nArray2[n3] = nArray2[n2];
        }
        for (n2 = n3 + 1; n2 < doubleIntIndex.size(); ++n2) {
            nArray[n2] = 0;
            nArray2[n2] = 0;
        }
        if (doubleIntIndex.size() != n3 + 1) {
            doubleIntIndex.setSize(n3 + 1);
            return true;
        }
        return false;
    }
}

