/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.surefire.common.junit4.ClassMethod;
import org.apache.maven.surefire.common.junit4.MatchDescriptions;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;

public final class JUnit4ProviderUtil {
    private JUnit4ProviderUtil() {
        throw new IllegalStateException("Cannot instantiate.");
    }

    public static Set<Description> generateFailingTestDescriptions(List<Failure> allFailures) {
        HashSet<Description> failingTestDescriptions = new HashSet<Description>();
        for (Failure failure : allFailures) {
            Description description = failure.getDescription();
            if (!description.isTest() || JUnit4ProviderUtil.isFailureInsideJUnitItself(description)) continue;
            failingTestDescriptions.add(description);
        }
        return failingTestDescriptions;
    }

    public static boolean isFailureInsideJUnitItself(Description failure) {
        return Description.TEST_MECHANISM.equals((Object)failure);
    }

    public static ClassMethod cutTestClassAndMethod(Description description) {
        int classBracket;
        String name = description.getDisplayName();
        String clazz = null;
        String method = null;
        if (name != null && (name = name.trim()).endsWith(")") && (classBracket = name.lastIndexOf(40)) != -1) {
            clazz = JUnit4ProviderUtil.tryBlank(name.substring(classBracket + 1, name.length() - 1));
            method = JUnit4ProviderUtil.tryBlank(name.substring(0, classBracket));
        }
        return new ClassMethod(clazz, method);
    }

    private static String tryBlank(String s) {
        return StringUtils.isBlank(s = s.trim()) ? null : s;
    }

    public static Filter createMatchAnyDescriptionFilter(Iterable<Description> descriptions) {
        return new MatchDescriptions(descriptions);
    }
}

