/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.RunOrder;

class BooterSerializer {
    private final ForkConfiguration forkConfiguration;
    private final PropertiesWrapper properties;

    public BooterSerializer(ForkConfiguration forkConfiguration, Properties properties) {
        this.forkConfiguration = forkConfiguration;
        this.properties = new PropertiesWrapper(properties);
    }

    public File serialize(ProviderConfiguration booterConfiguration, StartupConfiguration providerConfiguration, Object testSet, String forkMode) throws IOException {
        RunOrderParameters runOrderParameters;
        DirectoryScannerParameters directoryScannerParameters;
        providerConfiguration.getClasspathConfiguration().setForkProperties(this.properties);
        TestArtifactInfo testNg = booterConfiguration.getTestArtifact();
        if (testNg != null) {
            this.properties.setProperty("testFwJarVersion", testNg.getVersion());
            this.properties.setProperty("testFwJarClassifier", testNg.getClassifier());
        }
        this.properties.setProperty("forkTestSet", this.getTypeEncoded(testSet));
        TestRequest testSuiteDefinition = booterConfiguration.getTestSuiteDefinition();
        if (testSuiteDefinition != null) {
            this.properties.setProperty("testSuiteDefinitionTestSourceDirectory", testSuiteDefinition.getTestSourceDirectory());
            this.properties.addList(testSuiteDefinition.getSuiteXmlFiles(), "testSuiteXmlFiles");
            this.properties.setProperty("requestedTest", testSuiteDefinition.getRequestedTest());
            this.properties.setProperty("requestedTestMethod", testSuiteDefinition.getRequestedTestMethod());
        }
        if ((directoryScannerParameters = booterConfiguration.getDirScannerParams()) != null) {
            this.properties.setProperty("failIfNoTests", String.valueOf(directoryScannerParameters.isFailIfNoTests()));
            this.properties.addList(directoryScannerParameters.getIncludes(), "includes");
            this.properties.addList(directoryScannerParameters.getExcludes(), "excludes");
            this.properties.setProperty("testClassesDirectory", directoryScannerParameters.getTestClassesDirectory());
        }
        if ((runOrderParameters = booterConfiguration.getRunOrderParameters()) != null) {
            this.properties.setProperty("runOrder", RunOrder.asString((RunOrder[])runOrderParameters.getRunOrder()));
            this.properties.setProperty("runStatisticsFile", runOrderParameters.getRunStatisticsFile());
        }
        ReporterConfiguration reporterConfiguration = booterConfiguration.getReporterConfiguration();
        Boolean rep = reporterConfiguration.isTrimStackTrace();
        this.properties.setProperty("isTrimStackTrace", rep);
        this.properties.setProperty("reportsDirectory", reporterConfiguration.getReportsDirectory());
        this.properties.setProperty("forkMode", forkMode);
        ClassLoaderConfiguration classLoaderConfiguration = providerConfiguration.getClassLoaderConfiguration();
        this.properties.setProperty("useSystemClassLoader", String.valueOf(classLoaderConfiguration.isUseSystemClassLoader()));
        this.properties.setProperty("useManifestOnlyJar", String.valueOf(classLoaderConfiguration.isUseManifestOnlyJar()));
        this.properties.setProperty("failIfNoTests", String.valueOf(booterConfiguration.isFailIfNoTests()));
        this.properties.setProperty("providerConfiguration", providerConfiguration.getProviderClassName());
        return SystemPropertyManager.writePropertiesFile((Properties)this.properties.getProperties(), (File)this.forkConfiguration.getTempDirectory(), (String)"surefire", (boolean)this.forkConfiguration.isDebug());
    }

    private String getTypeEncoded(Object value) {
        if (value == null) {
            return null;
        }
        String valueToUse = value instanceof Class ? ((Class)value).getName() : value.toString();
        return value.getClass().getName() + "|" + valueToUse;
    }
}

