/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.incremental;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanResult;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalBuildHelper {
    private static final String MAVEN_STATUS_ROOT = "maven-status";
    public static final String CREATED_FILES_LST_FILENAME = "createdFiles.lst";
    private static final String INPUT_FILES_LST_FILENAME = "inputFiles.lst";
    private MojoExecution mojoExecution;
    private MavenProject mavenProject;
    private DirectoryScanner directoryScanner;
    private String[] filesBeforeAction = new String[0];

    public IncrementalBuildHelper(MojoExecution mojoExecution, MavenSession mavenSession) {
        this(mojoExecution, IncrementalBuildHelper.getMavenProject(mavenSession));
    }

    public IncrementalBuildHelper(MojoExecution mojoExecution, MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException("MavenProject must not be null!");
        }
        if (mojoExecution == null) {
            throw new IllegalArgumentException("MojoExecution must not be null!");
        }
        this.mavenProject = mavenProject;
        this.mojoExecution = mojoExecution;
    }

    private static MavenProject getMavenProject(MavenSession mavenSession) {
        if (mavenSession == null) {
            throw new IllegalArgumentException("MavenSession must not be null!");
        }
        return mavenSession.getCurrentProject();
    }

    public DirectoryScanner getDirectoryScanner() {
        if (this.directoryScanner == null) {
            this.directoryScanner = new DirectoryScanner();
        }
        return this.directoryScanner;
    }

    public void setDirectoryScanner(DirectoryScanner directoryScanner) {
        this.directoryScanner = directoryScanner;
    }

    public File getMojoStatusDirectory() throws MojoExecutionException {
        String mojoStatusPath;
        if (this.mojoExecution == null) {
            throw new MojoExecutionException("MojoExecution could not get resolved");
        }
        File buildOutputDirectory = new File(this.mavenProject.getBuild().getDirectory());
        File mojoStatusDir = new File(buildOutputDirectory, mojoStatusPath = MAVEN_STATUS_ROOT + File.separator + this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getArtifactId() + File.separator + this.mojoExecution.getMojoDescriptor().getGoal() + File.separator + this.mojoExecution.getExecutionId());
        if (!mojoStatusDir.exists()) {
            mojoStatusDir.mkdirs();
        }
        return mojoStatusDir;
    }

    public boolean inputFileTreeChanged(Set<File> inputFiles) throws MojoExecutionException {
        File mojoConfigBase = this.getMojoStatusDirectory();
        File mojoConfigFile = new File(mojoConfigBase, INPUT_FILES_LST_FILENAME);
        String[] oldInputFiles = new String[]{};
        if (mojoConfigFile.exists()) {
            try {
                oldInputFiles = FileUtils.fileReadArray((File)mojoConfigFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading old mojo status " + mojoConfigFile, (Exception)e);
            }
        }
        String[] inputFileNames = new String[inputFiles.size()];
        int i = 0;
        for (File inputFile : inputFiles) {
            inputFileNames[i++] = inputFile.getAbsolutePath();
        }
        DirectoryScanResult dsr = DirectoryScanner.diffFiles((String[])oldInputFiles, (String[])inputFileNames);
        try {
            FileUtils.fileWriteArray((File)mojoConfigFile, (String[])inputFileNames);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while storing the mojo status", (Exception)e);
        }
        return dsr.getFilesAdded().length > 0 || dsr.getFilesRemoved().length > 0;
    }

    public boolean inputFileTreeChanged(DirectoryScanner dirScanner) throws MojoExecutionException {
        File mojoConfigBase = this.getMojoStatusDirectory();
        File mojoConfigFile = new File(mojoConfigBase, INPUT_FILES_LST_FILENAME);
        String[] oldInputFiles = new String[]{};
        if (mojoConfigFile.exists()) {
            try {
                oldInputFiles = FileUtils.fileReadArray((File)mojoConfigFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading old mojo status " + mojoConfigFile, (Exception)e);
            }
        }
        dirScanner.scan();
        try {
            FileUtils.fileWriteArray((File)mojoConfigFile, (String[])dirScanner.getIncludedFiles());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while storing new mojo status" + mojoConfigFile, (Exception)e);
        }
        DirectoryScanResult dsr = dirScanner.diffIncludedFiles(oldInputFiles);
        return dsr.getFilesAdded().length > 0 || dsr.getFilesRemoved().length > 0;
    }

    public String[] beforeRebuildExecution(File outputDirectory) throws MojoExecutionException {
        String[] oldFiles;
        File mojoConfigBase = this.getMojoStatusDirectory();
        File mojoConfigFile = new File(mojoConfigBase, CREATED_FILES_LST_FILENAME);
        try {
            for (String oldFileName : oldFiles = FileUtils.fileReadArray((File)mojoConfigFile)) {
                File oldFile = new File(outputDirectory, oldFileName);
                oldFile.delete();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading old mojo status", (Exception)e);
        }
        DirectoryScanner diffScanner = this.getDirectoryScanner();
        diffScanner.setBasedir(outputDirectory);
        if (outputDirectory.exists()) {
            diffScanner.scan();
            this.filesBeforeAction = diffScanner.getIncludedFiles();
        }
        return oldFiles;
    }

    public void afterRebuildExecution() throws MojoExecutionException {
        DirectoryScanner diffScanner = this.getDirectoryScanner();
        diffScanner.scan();
        DirectoryScanResult scanResult = diffScanner.diffIncludedFiles(this.filesBeforeAction);
        File mojoConfigBase = this.getMojoStatusDirectory();
        File mojoConfigFile = new File(mojoConfigBase, CREATED_FILES_LST_FILENAME);
        try {
            FileUtils.fileWriteArray((File)mojoConfigFile, (String[])scanResult.getFilesAdded());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while storing the mojo status", (Exception)e);
        }
    }
}

