/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.unedit;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarteamUnEditConsumer
implements StreamConsumer {
    private String workingDirectory;
    private ScmLogger logger;
    private List<ScmFile> files = new ArrayList<ScmFile>();
    private String currentDir = "";
    private static final String DIR_MARKER = "(working dir: ";
    private static final String UNLOCKED_MARKER = ": unlocked";

    public StarteamUnEditConsumer(ScmLogger logger, File basedir) {
        this.logger = logger;
        this.workingDirectory = basedir.getPath().replace('\\', '/');
    }

    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        int pos = 0;
        pos = line.indexOf(DIR_MARKER);
        if (pos != -1) {
            this.processDirectory(line, pos);
        } else {
            pos = line.indexOf(UNLOCKED_MARKER);
            if (pos != -1) {
                this.processUnLockedFile(line, pos);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unknown unedit ouput: " + line);
            }
        }
    }

    public List<ScmFile> getUnEditFiles() {
        return this.files;
    }

    private void processDirectory(String line, int pos) {
        String dirPath = line.substring(pos + DIR_MARKER.length(), line.length() - 1).replace('\\', '/');
        if (!dirPath.startsWith(this.workingDirectory)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Working directory: " + this.workingDirectory);
                this.logger.info("unedit directory: " + dirPath);
            }
            throw new IllegalStateException("Working and unedit directories are not on the same tree");
        }
        this.currentDir = "." + dirPath.substring(this.workingDirectory.length());
    }

    private void processUnLockedFile(String line, int pos) {
        String lockedFilePath = this.currentDir + "/" + line.substring(0, pos);
        this.files.add(new ScmFile(lockedFilePath, ScmFileStatus.UNKNOWN));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Unlocked: " + lockedFilePath);
        }
    }
}

