/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.SiteMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, requiresReports=true)
public class SiteJarMojo
extends SiteMojo {
    private static final String[] DEFAULT_ARCHIVE_EXCLUDES = new String[0];
    private static final String[] DEFAULT_ARCHIVE_INCLUDES = new String[]{"**/**"};
    @Parameter(property="project.build.directory", required=true)
    private String jarOutputDirectory;
    @Parameter(property="project.build.finalName", required=true)
    private String finalName;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="site.attach", defaultValue="true")
    private boolean attach;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter
    private String[] archiveIncludes;
    @Parameter
    private String[] archiveExcludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.outputDirectory.exists()) {
            super.execute();
        }
        try {
            File outputFile = this.createArchive(this.outputDirectory, this.finalName + "-" + this.getClassifier() + "." + this.getArtifactType());
            if (this.attach) {
                this.projectHelper.attachArtifact(this.project, this.getArtifactType(), this.getClassifier(), outputFile);
            } else {
                this.getLog().info((CharSequence)"NOT adding site jar to the list of attached artifacts.");
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)e);
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)((Object)e));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)((Object)e));
        }
    }

    protected String getArtifactType() {
        return "jar";
    }

    protected String getClassifier() {
        return "site";
    }

    private File createArchive(File siteDirectory, String jarFilename) throws ArchiverException, IOException, ManifestException, DependencyResolutionRequiredException {
        File siteJar = new File(this.jarOutputDirectory, jarFilename);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(siteJar);
        if (!siteDirectory.isDirectory()) {
            this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion !");
        } else {
            archiver.getArchiver().addDirectory(siteDirectory, this.getArchiveIncludes(), this.getArchiveExcludes());
        }
        archiver.createArchive(this.project, this.archive);
        return siteJar;
    }

    private String[] getArchiveIncludes() {
        if (this.archiveIncludes != null && this.archiveIncludes.length > 0) {
            return this.archiveIncludes;
        }
        return DEFAULT_ARCHIVE_INCLUDES;
    }

    private String[] getArchiveExcludes() {
        if (this.archiveExcludes != null && this.archiveExcludes.length > 0) {
            return this.archiveExcludes;
        }
        return DEFAULT_ARCHIVE_EXCLUDES;
    }
}

