/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.jxr.JXR;
import org.apache.maven.jxr.JxrException;
import org.apache.maven.jxr.log.Log;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.jxr.JxrReportUtil;
import org.apache.maven.plugin.jxr.PluginLogAdapter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJxrReport
extends AbstractMavenReport {
    private MavenProject project;
    private Renderer siteRenderer;
    private File outputDirectory;
    private String inputEncoding;
    private String outputEncoding;
    private String windowTitle;
    private String docTitle;
    private String bottom;
    private String templateDir;
    private String stylesheet;
    private ArrayList excludes;
    private ArrayList includes;
    protected List reactorProjects;
    protected boolean aggregate;
    protected boolean skip;
    private boolean linkJavadoc;

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected List pruneSourceDirs(List sourceDirs) {
        ArrayList<String> pruned = new ArrayList<String>(sourceDirs.size());
        for (String dir : sourceDirs) {
            if (pruned.contains(dir) || !this.hasSources(new File(dir))) continue;
            pruned.add(dir);
        }
        return pruned;
    }

    protected void init() {
        block1: {
            ReportPlugin reportPlugin;
            List plugin = this.project.getReportPlugins();
            if (plugin == null) break block1;
            Iterator iter = plugin.iterator();
            while (iter.hasNext() && !"maven-javadoc-plugin".equals((reportPlugin = (ReportPlugin)iter.next()).getArtifactId())) {
            }
        }
    }

    private boolean hasSources(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File currentFile = files[i];
                if (!(currentFile.isFile() ? currentFile.getName().endsWith(".java") : Character.isJavaIdentifierStart(currentFile.getName().charAt(0)) && this.hasSources(currentFile))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXref(Locale locale, String destinationDirectory, List sourceDirs) throws IOException, JxrException {
        JXR jxr = new JXR();
        jxr.setDest(destinationDirectory);
        if (StringUtils.isEmpty((String)this.inputEncoding)) {
            String platformEncoding = System.getProperty("file.encoding");
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + platformEncoding + ", i.e. build is platform dependent!"));
        }
        jxr.setInputEncoding(this.inputEncoding);
        jxr.setLocale(locale);
        jxr.setLog((Log)new PluginLogAdapter(this.getLog()));
        jxr.setOutputEncoding(this.getOutputEncoding());
        jxr.setRevision("HEAD");
        jxr.setJavadocLinkDir(this.getJavadocLocation());
        if (this.excludes != null && !this.excludes.isEmpty()) {
            jxr.setExcludes(this.excludes.toArray(new String[0]));
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            jxr.setIncludes(this.includes.toArray(new String[0]));
        }
        ClassLoader savedTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            jxr.xref(sourceDirs, this.templateDir, this.windowTitle, this.docTitle, this.getBottomText());
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedTccl);
        }
        this.copyRequiredResources(destinationDirectory);
    }

    private String getBottomText() {
        int currentYear = Calendar.getInstance().get(1);
        String year = String.valueOf(currentYear);
        String inceptionYear = this.project.getInceptionYear();
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}&#x2013;", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}&#x2013;", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }

    private void copyRequiredResources(String dir) {
        File stylesheetFile = new File(this.stylesheet);
        File destStylesheetFile = new File(dir, "stylesheet.css");
        try {
            if (stylesheetFile.isAbsolute()) {
                FileUtils.copyFile((File)stylesheetFile, (File)destStylesheetFile);
            } else {
                URL stylesheetUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.stylesheet);
                FileUtils.copyURLToFile((URL)stylesheetUrl, (File)destStylesheetFile);
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"An error occured while copying the stylesheet to the target directory", (Throwable)e);
        }
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jxr-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected boolean canGenerateReport(List sourceDirs) {
        boolean canGenerate;
        boolean bl = canGenerate = !sourceDirs.isEmpty();
        if (this.isAggregate() && !this.project.isExecutionRoot()) {
            canGenerate = false;
        }
        return canGenerate;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping JXR.");
            return;
        }
        Locale locale = Locale.getDefault();
        try {
            this.executeReport(locale);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Error generating JXR report", (Exception)((Object)e));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping JXR.");
            return;
        }
        List sourceDirs = this.constructSourceDirs();
        if (this.canGenerateReport(sourceDirs)) {
            this.init();
            try {
                this.createXref(locale, this.getDestinationDirectory(), sourceDirs);
            }
            catch (JxrException e) {
                throw new MavenReportException("Error while generating the HTML source code of the projet.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MavenReportException("Error while generating the HTML source code of the projet.", (Exception)e);
            }
        }
    }

    protected List constructSourceDirs() {
        List sourceDirs = new ArrayList(this.getSourceRoots());
        if (this.isAggregate()) {
            for (MavenProject project : this.reactorProjects) {
                if (!"java".equals(project.getArtifact().getArtifactHandler().getLanguage())) continue;
                sourceDirs.addAll(this.getSourceRoots(project));
            }
        }
        sourceDirs = this.pruneSourceDirs(sourceDirs);
        return sourceDirs;
    }

    public boolean canGenerateReport() {
        return this.canGenerateReport(this.constructSourceDirs());
    }

    public boolean isExternalReport() {
        return true;
    }

    private String getJavadocLocation() throws IOException {
        String location = null;
        if (this.linkJavadoc) {
            if (this.getJavadocDir().exists()) {
                location = this.getJavadocDir().getAbsolutePath();
            } else {
                String stagingDirectory = System.getProperty("stagingDirectory");
                if (StringUtils.isNotEmpty((String)stagingDirectory)) {
                    String javadocDestDir = this.getJavadocDir().getName();
                    boolean javadocAggregate = JxrReportUtil.isJavadocAggregated(this.project);
                    String structureProject = JxrReportUtil.getStructure(this.project, false);
                    if (this.isAggregate() && javadocAggregate) {
                        File outputDirectory = new File(stagingDirectory, structureProject);
                        location = outputDirectory + "/" + javadocDestDir;
                    }
                    if (!this.isAggregate() && javadocAggregate) {
                        location = stagingDirectory + "/" + javadocDestDir;
                        String hierarchy = this.project.getName();
                        for (MavenProject parent = this.project.getParent(); parent != null; parent = parent.getParent()) {
                            hierarchy = parent.getName();
                        }
                        File outputDirectory = new File(stagingDirectory, hierarchy);
                        location = outputDirectory + "/" + javadocDestDir;
                    }
                    if (this.isAggregate() && !javadocAggregate) {
                        this.getLog().warn((CharSequence)"The JXR plugin is configured to build an aggregated report at the root, not the Javadoc plugin.");
                    }
                    if (!this.isAggregate() && !javadocAggregate) {
                        location = stagingDirectory + "/" + structureProject + "/" + javadocDestDir;
                    }
                } else {
                    location = this.getJavadocDir().getAbsolutePath();
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Javadoc to link to - DISABLED");
            }
        }
        return location;
    }

    protected abstract String getDestinationDirectory();

    protected abstract List getSourceRoots();

    protected abstract List getSourceRoots(MavenProject var1);

    protected abstract File getJavadocDir();

    protected boolean isAggregate() {
        return this.aggregate;
    }
}

