/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.help.AbstractEffectiveMojo;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EffectiveSettingsMojo
extends AbstractEffectiveMojo {
    private Settings settings;
    private boolean showPasswords;

    public void execute() throws MojoExecutionException {
        Settings copySettings;
        if (this.showPasswords) {
            copySettings = this.settings;
        } else {
            copySettings = EffectiveSettingsMojo.copySettings(this.settings);
            EffectiveSettingsMojo.hidePasswords(copySettings);
        }
        StringWriter w = new StringWriter();
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), copySettings.getModelEncoding(), null);
        EffectiveSettingsMojo.writeHeader((XMLWriter)writer);
        EffectiveSettingsMojo.writeEffectiveSettings(copySettings, (XMLWriter)writer);
        String effectiveSettings = w.toString();
        if (this.output != null) {
            try {
                EffectiveSettingsMojo.writeXmlFile(this.output, effectiveSettings, copySettings.getModelEncoding());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-settings to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Effective-settings written to: " + this.output));
            }
        } else {
            StringBuffer message = new StringBuffer();
            message.append("\nEffective user-specific configuration settings:\n\n");
            message.append(effectiveSettings);
            message.append("\n");
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)message.toString());
            }
        }
    }

    private static void hidePasswords(Settings aSettings) {
        Iterator it = aSettings.getProxies().iterator();
        while (it.hasNext()) {
            Proxy proxy = (Proxy)it.next();
            if (!StringUtils.isNotEmpty((String)proxy.getPassword())) continue;
            proxy.setPassword(StringUtils.repeat((String)"*", (int)proxy.getPassword().length()));
        }
        it = aSettings.getServers().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            if (!StringUtils.isNotEmpty((String)server.getPassword())) continue;
            server.setPassword(StringUtils.repeat((String)"*", (int)server.getPassword().length()));
        }
    }

    private static Settings copySettings(Settings settings) {
        if (settings == null) {
            return null;
        }
        Settings clone = new Settings();
        clone.setActiveProfiles(settings.getActiveProfiles());
        clone.setInteractiveMode(settings.isInteractiveMode());
        clone.setLocalRepository(settings.getLocalRepository());
        clone.setMirrors(settings.getMirrors());
        clone.setOffline(settings.isOffline());
        clone.setPluginGroups(settings.getPluginGroups());
        clone.setProfiles(settings.getProfiles());
        clone.setProxies(settings.getProxies());
        clone.setRuntimeInfo(settings.getRuntimeInfo());
        clone.setServers(settings.getServers());
        clone.setSourceLevel(settings.getSourceLevel());
        clone.setUsePluginRegistry(settings.isUsePluginRegistry());
        return clone;
    }

    private static void writeEffectiveSettings(Settings settings, XMLWriter writer) throws MojoExecutionException {
        EffectiveSettingsMojo.cleanSettings(settings);
        StringWriter sWriter = new StringWriter();
        SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
        try {
            settingsWriter.write((Writer)sWriter, settings);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize Settings to XML.", (Exception)e);
        }
        String effectiveSettings = EffectiveSettingsMojo.addMavenNamespace(sWriter.toString(), false);
        EffectiveSettingsMojo.writeComment(writer, "Effective Settings for '" + EffectiveSettingsMojo.getUserName() + "' on '" + EffectiveSettingsMojo.getHostName() + "'");
        writer.writeMarkup(effectiveSettings);
    }

    private static void cleanSettings(Settings settings) {
        Iterator it = settings.getProfiles().iterator();
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            AbstractEffectiveMojo.SortedProperties properties = new AbstractEffectiveMojo.SortedProperties();
            properties.putAll((Map<?, ?>)profile.getProperties());
            profile.setProperties((Properties)properties);
        }
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private static String getUserName() {
        String userName = System.getProperty("user.name");
        if (StringUtils.isEmpty((String)userName)) {
            return "unknown";
        }
        return userName;
    }
}

