/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.rad;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.JeeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class RadWebSettingsWriter
extends AbstractEclipseWriter {
    private static final String COM_IBM_ETOOLS_SITEEDIT_WIZARDS_PROJECTFEATURE_WEB_SITE_FEATURE = "com.ibm.etools.siteedit.wizards.projectfeature.WebSiteFeature";
    private static final String WEBSETTINGS_CONTEXT_ROOT = "context-root";
    private static final String WEBSETTINGS_FEATURE = "feature";
    private static final String WEBSETTINGS_FEATURE_ID = "feature-id";
    private static final String WEBSETTINGS_FEATURES = "features";
    private static final String WEBSETTINGS_FILENAME = ".websettings";
    private static final String WEBSETTINGS_JSP_LEVEL = "jsp-level";
    private static final String WEBSETTINGS_PROJECT_TYPE = "project-type";
    private static final String WEBSETTINGS_TEMPLATEFEATURE = "templatefeature";
    private static final String WEBSETTINGS_VERSION = "version";
    private static final String WEBSETTINGS_WEBCONTENT = "webcontent";
    private static final String WEBSETTINGS_WEBSETTINGS = "websettings";
    private String warContextRoot;

    public RadWebSettingsWriter(String warContextRoot) {
        this.warContextRoot = warContextRoot;
    }

    public void write() throws MojoExecutionException {
        if ("war".equalsIgnoreCase(this.config.getProject().getPackaging())) {
            FileWriter w;
            try {
                w = new FileWriter(new File(this.config.getEclipseProjectDirectory(), WEBSETTINGS_FILENAME));
            }
            catch (IOException ex) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
            }
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
            this.writeModuleTypeFacetCore((XMLWriter)writer);
            IOUtil.close((Writer)w);
        }
    }

    private void writeModuleTypeFacetCore(XMLWriter writer) {
        writer.startElement(WEBSETTINGS_WEBSETTINGS);
        writer.addAttribute(WEBSETTINGS_VERSION, "600");
        writer.startElement(WEBSETTINGS_WEBCONTENT);
        writer.writeText("src/main/webapp");
        writer.endElement();
        writer.startElement(WEBSETTINGS_CONTEXT_ROOT);
        writer.writeText(this.getContextRoot(this.warContextRoot));
        writer.endElement();
        writer.startElement(WEBSETTINGS_PROJECT_TYPE);
        writer.writeText("J2EE");
        writer.endElement();
        writer.startElement(WEBSETTINGS_JSP_LEVEL);
        writer.writeText(JeeUtils.resolveJspVersion(this.config.getProject()));
        writer.endElement();
        writer.startElement(WEBSETTINGS_FEATURES);
        writer.startElement(WEBSETTINGS_FEATURE);
        writer.startElement(WEBSETTINGS_FEATURE_ID);
        writer.writeText(WEBSETTINGS_TEMPLATEFEATURE);
        writer.endElement();
        writer.endElement();
        writer.startElement(WEBSETTINGS_FEATURE);
        writer.startElement(WEBSETTINGS_FEATURE_ID);
        writer.writeText(COM_IBM_ETOOLS_SITEEDIT_WIZARDS_PROJECTFEATURE_WEB_SITE_FEATURE);
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
    }

    private String getContextRoot(String warContextRoot) {
        if (warContextRoot == null || warContextRoot.length() == 0) {
            return this.config.getProject().getArtifactId();
        }
        return warContextRoot;
    }
}

