/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JavaModule
extends AbstractEarModule {
    protected static final String JAVA_MODULE = "java";
    private Boolean includeInApplicationXml = Boolean.FALSE;

    public JavaModule() {
    }

    public JavaModule(Artifact a, String defaultJavaBundleDir) {
        super(a);
        this.setJavaBundleDir(defaultJavaBundleDir);
    }

    public void appendModule(XMLWriter writer, String version) {
        if (this.includeInApplicationXml.booleanValue()) {
            writer.startElement("module");
            writer.startElement(JAVA_MODULE);
            writer.writeText(this.getUri());
            writer.endElement();
            writer.endElement();
        }
    }

    public void resolveArtifact(Set artifacts, String defaultJavaBundleDir) throws EarPluginException, MojoFailureException {
        super.resolveArtifact(artifacts, defaultJavaBundleDir);
        this.setJavaBundleDir(defaultJavaBundleDir);
    }

    protected String getType() {
        return "jar";
    }

    private void setJavaBundleDir(String defaultJavaBundleDir) {
        if (defaultJavaBundleDir != null && this.bundleDir == null) {
            this.bundleDir = defaultJavaBundleDir;
        }
    }
}

