/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.TransferUtils;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.Node;
import org.apache.maven.shared.artifact.filter.resolve.PatternExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternInclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="purge-local-repository", threadSafe=true, requiresProject=false)
public class PurgeLocalRepositoryMojo
extends AbstractMojo {
    public static final String FILE_FUZZINESS = "file";
    public static final String VERSION_FUZZINESS = "version";
    public static final String ARTIFACT_ID_FUZZINESS = "artifactId";
    public static final String GROUP_ID_FUZZINESS = "groupId";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private List<String> manualIncludes;
    @Parameter(property="manualInclude")
    private String manualInclude;
    @Parameter
    private List<String> includes;
    @Parameter(property="include")
    private String include;
    @Parameter
    private List<String> excludes;
    @Parameter(property="exclude")
    private String exclude;
    @Parameter(property="reResolve", defaultValue="true")
    private boolean reResolve;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(property="resolutionFuzziness", defaultValue="version")
    private String resolutionFuzziness;
    @Parameter(property="actTransitively", defaultValue="true")
    private boolean actTransitively;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="snapshotsOnly", defaultValue="false")
    private boolean snapshotsOnly;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TransformableFilter dependencyFilter;
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (!StringUtils.isEmpty((String)this.manualInclude)) {
            this.manualIncludes = this.parseIncludes(this.manualInclude);
        }
        if (this.manualIncludes != null && this.manualIncludes.size() > 0) {
            this.manualPurge(this.manualIncludes);
            return;
        }
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        Set<Artifact> resolvedArtifactsToPurge = this.getFilteredResolvedArtifacts(this.project, dependencyArtifacts, dependencyFilter = this.createPurgeArtifactsFilter(dependencyArtifacts));
        if (resolvedArtifactsToPurge.isEmpty()) {
            this.getLog().info((CharSequence)("No artifacts included for purge for project: " + this.project.getId()));
            return;
        }
        this.verbose("Purging dependencies for project: " + this.project.getId());
        this.purgeArtifacts(resolvedArtifactsToPurge);
        if (this.reResolve) {
            ArtifactFilter artifactFilter = (ArtifactFilter)dependencyFilter.transform((FilterTransformer)new ArtifactIncludeFilterTransformer());
            try {
                this.reResolveArtifacts(this.project, resolvedArtifactsToPurge, artifactFilter);
            }
            catch (ArtifactResolutionException e) {
                String failureMessage = "Failed to refresh project dependencies for: " + this.project.getId();
                MojoFailureException failure = new MojoFailureException(failureMessage);
                failure.initCause((Throwable)e);
                throw failure;
            }
            catch (ArtifactNotFoundException e) {
                String failureMessage = "Failed to refresh project dependencies for: " + this.project.getId();
                MojoFailureException failure = new MojoFailureException(failureMessage);
                failure.initCause((Throwable)e);
                throw failure;
            }
        }
    }

    private void manualPurge(List<String> includes) throws MojoExecutionException {
        for (String gavPattern : includes) {
            File purgeDir;
            if (StringUtils.isEmpty((String)gavPattern)) {
                this.getLog().debug((CharSequence)("Skipping empty gav pattern: " + gavPattern));
                continue;
            }
            String relativePath = this.gavToPath(gavPattern);
            if (StringUtils.isEmpty((String)relativePath) || !(purgeDir = new File(this.localRepository.getBasedir(), relativePath)).exists()) continue;
            this.getLog().debug((CharSequence)("Deleting directory: " + purgeDir));
            try {
                FileUtils.deleteDirectory((File)purgeDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to purge directory: " + purgeDir);
            }
        }
    }

    private String gavToPath(String gav) {
        if (StringUtils.isEmpty((String)gav)) {
            return null;
        }
        String[] pathComponents = gav.split(":");
        StringBuilder path = new StringBuilder(pathComponents[0].replace('.', '/'));
        for (int i = 1; i < pathComponents.length; ++i) {
            path.append("/").append(pathComponents[i]);
        }
        return path.toString();
    }

    private TransformableFilter createPurgeArtifactsFilter(Set<Artifact> dependencyArtifacts) {
        ArrayList<Object> subFilters = new ArrayList<Object>();
        subFilters.add(ScopeFilter.excluding((String[])new String[]{"system"}));
        if (this.snapshotsOnly) {
            subFilters.add((Object)new SnapshotsFilter());
        }
        if (!StringUtils.isEmpty((String)this.include)) {
            this.includes = this.parseIncludes(this.include);
        }
        if (this.includes != null) {
            subFilters.add(new PatternInclusionsFilter(this.includes));
        }
        if (!StringUtils.isEmpty((String)this.exclude)) {
            this.excludes = this.parseIncludes(this.exclude);
        }
        if (this.excludes != null) {
            subFilters.add(new PatternExclusionsFilter(this.excludes));
        }
        if (!this.actTransitively) {
            subFilters.add((Object)new DirectDependencyFilter(this.project.getArtifact(), dependencyArtifacts));
        }
        return new AndFilter(subFilters);
    }

    private List<String> parseIncludes(String include) {
        ArrayList<String> includes = new ArrayList<String>();
        if (include != null) {
            String[] elements = include.split(",");
            includes.addAll(Arrays.asList(elements));
        }
        return includes;
    }

    private Set<Artifact> getFilteredResolvedArtifacts(MavenProject project, Set<Artifact> artifacts, TransformableFilter filter) {
        try {
            Iterable results = this.dependencyResolver.resolveDependencies(this.session.getProjectBuildingRequest(), project.getModel(), filter);
            LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
            for (ArtifactResult artResult : results) {
                resolvedArtifacts.add(artResult.getArtifact());
            }
            return resolvedArtifacts;
        }
        catch (DependencyResolverException e) {
            this.getLog().info((CharSequence)("Unable to resolve all dependencies for : " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion() + ". Falling back to non-transitive mode for initial artifact resolution."));
            LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
            ArtifactFilter artifactFilter = (ArtifactFilter)filter.transform((FilterTransformer)new ArtifactIncludeFilterTransformer());
            for (Artifact artifact : artifacts) {
                if (!artifactFilter.include(artifact)) continue;
                try {
                    ArtifactResult artifactResult = this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), artifact);
                    resolvedArtifacts.add(artifactResult.getArtifact());
                }
                catch (ArtifactResolverException e2) {
                    this.getLog().debug((CharSequence)("Unable to resolve artifact: " + artifact));
                }
            }
            return resolvedArtifacts;
        }
    }

    private void purgeArtifacts(Set<Artifact> artifacts) throws MojoFailureException {
        for (Artifact artifact : artifacts) {
            this.verbose("Purging artifact: " + artifact.getId());
            File deleteTarget = this.findDeleteTarget(artifact);
            this.verbose("Deleting: " + deleteTarget);
            if (deleteTarget.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)deleteTarget);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Unable to purge local repository location: " + deleteTarget), (Throwable)e);
                }
            } else if (!deleteTarget.delete()) {
                deleteTarget.deleteOnExit();
                this.getLog().warn((CharSequence)("Unable to purge local repository location immediately: " + deleteTarget));
            }
            artifact.setResolved(false);
        }
    }

    private void reResolveArtifacts(MavenProject project, Set<Artifact> artifacts, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (Artifact artifact : artifacts) {
            try {
                this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), TransferUtils.toArtifactCoordinate((Artifact)artifact));
            }
            catch (ArtifactResolverException e) {
                this.verbose(e.getMessage());
            }
        }
        ArrayList<Artifact> missingArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            this.verbose("Resolving artifact: " + artifact.getId());
            try {
                this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), artifact);
            }
            catch (ArtifactResolverException e) {
                this.verbose(e.getMessage());
                missingArtifacts.add(artifact);
            }
        }
        if (missingArtifacts.size() > 0) {
            StringBuffer message = new StringBuffer("required artifacts missing:\n");
            for (Artifact missingArtifact : missingArtifacts) {
                message.append("  ").append(missingArtifact.getId()).append('\n');
            }
            message.append("\nfor the artifact:");
            throw new ArtifactResolutionException(message.toString(), project.getArtifact(), project.getRemoteArtifactRepositories());
        }
    }

    private File findDeleteTarget(Artifact artifact) {
        File deleteTarget = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
        if (GROUP_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile().getParentFile();
        } else if (ARTIFACT_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile();
        } else if (VERSION_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile();
        }
        return deleteTarget;
    }

    private void verbose(String message) {
        if (this.verbose || this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)message);
        }
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private class SnapshotsFilter
    extends AbstractFilter {
        private SnapshotsFilter() {
        }

        public boolean accept(Node node, List<Node> parents) {
            if (node.getDependency() == null) {
                return false;
            }
            return ArtifactUtils.isSnapshot((String)node.getDependency().getVersion());
        }
    }

    private class DirectDependencyFilter
    extends AbstractFilter {
        private Artifact projectArtifact;
        private Set<Artifact> directDependencyArtifacts;

        public DirectDependencyFilter(Artifact projectArtifact, Set<Artifact> directDependencyArtifacts) {
            this.projectArtifact = projectArtifact;
            this.directDependencyArtifacts = directDependencyArtifacts;
        }

        public boolean accept(Node node, List<Node> parents) {
            if (this.artifactsGAMatch(node, this.projectArtifact)) {
                return true;
            }
            for (Artifact depArtifact : this.directDependencyArtifacts) {
                if (!this.artifactsGAMatch(node, depArtifact)) continue;
                return true;
            }
            return false;
        }

        private boolean artifactsGAMatch(Node node, Artifact artifact2) {
            if (node.getDependency() == null) {
                return false;
            }
            if (!node.getDependency().getGroupId().equals(artifact2.getGroupId())) {
                PurgeLocalRepositoryMojo.this.getLog().debug((CharSequence)("Different groupId: " + node.getDependency() + "  " + artifact2));
                return false;
            }
            if (!node.getDependency().getArtifactId().equals(artifact2.getArtifactId())) {
                PurgeLocalRepositoryMojo.this.getLog().debug((CharSequence)("Different artifactId: " + node.getDependency() + "  " + artifact2));
                return false;
            }
            return true;
        }
    }
}

