/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.jira.JiraHelper;
import org.apache.maven.plugin.jira.JiraXML;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJiraDownloader {
    private static final String UTF_8 = "UTF-8";
    protected Log log;
    private File output;
    private int nbEntriesMax;
    private String filter;
    private String fixVersionIds;
    private String statusIds;
    private String resolutionIds;
    private String priorityIds;
    private String component;
    private String typeIds;
    private String sortColumnNames;
    private String jiraUser;
    private String jiraPassword;
    private String webUser;
    private String webPassword;
    private MavenProject project;
    private Settings settings;
    protected final Map<String, String> statusMap = new HashMap<String, String>(8);
    protected final Map<String, String> resolutionMap = new HashMap<String, String>(8);
    protected final Map<String, String> priorityMap = new HashMap<String, String>(8);
    protected final Map<String, String> typeMap = new HashMap<String, String>(8);
    protected String jiraDatePattern;

    private String createFilter() {
        if (this.filter != null && this.filter.length() > 0) {
            return this.filter;
        }
        StringBuffer localFilter = new StringBuffer(16);
        if (this.fixVersionIds != null) {
            String[] fixVersions = this.fixVersionIds.split(",");
            for (int i = 0; i < fixVersions.length; ++i) {
                if (fixVersions[i].length() <= 0) continue;
                localFilter.append("&fixfor=").append(fixVersions[i].trim());
            }
        }
        if (this.statusIds != null) {
            String[] stats;
            for (String stat : stats = this.statusIds.split(",")) {
                String statusParam = this.statusMap.get(stat = stat.trim());
                if (statusParam != null) {
                    localFilter.append("&statusIds=").append(statusParam);
                    continue;
                }
                try {
                    Integer.parseInt(stat);
                    localFilter.append("&statusIds=").append(stat);
                }
                catch (NumberFormatException nfe) {
                    this.getLog().error((CharSequence)("maven-changes-plugin: invalid statusId " + stat));
                }
            }
        }
        if (this.priorityIds != null) {
            String[] prios;
            for (String prio : prios = this.priorityIds.split(",")) {
                String priorityParam = this.priorityMap.get(prio = prio.trim());
                if (priorityParam == null) continue;
                localFilter.append("&priorityIds=").append(priorityParam);
            }
        }
        if (this.resolutionIds != null) {
            String[] resos;
            for (String reso : resos = this.resolutionIds.split(",")) {
                String resoParam = this.resolutionMap.get(reso = reso.trim());
                if (resoParam == null) continue;
                localFilter.append("&resolutionIds=").append(resoParam);
            }
        }
        if (this.component != null) {
            String[] components;
            for (String component : components = this.component.split(",")) {
                if ((component = component.trim()).length() <= 0) continue;
                localFilter.append("&component=").append(component);
            }
        }
        if (this.typeIds != null) {
            String[] types;
            for (String type : types = this.typeIds.split(",")) {
                String typeParam = this.typeMap.get(type.trim());
                if (typeParam == null) continue;
                localFilter.append("&type=").append(typeParam);
            }
        }
        int validSortColumnNames = 0;
        if (this.sortColumnNames != null) {
            String[] sortColumnNamesArray = this.sortColumnNames.split(",");
            for (int i = sortColumnNamesArray.length - 1; i >= 0; --i) {
                String lowerColumnName = sortColumnNamesArray[i].trim().toLowerCase(Locale.ENGLISH);
                boolean descending = false;
                String fieldName = null;
                if (lowerColumnName.endsWith("desc")) {
                    descending = true;
                    lowerColumnName = lowerColumnName.substring(0, lowerColumnName.length() - 4).trim();
                } else if (lowerColumnName.endsWith("asc")) {
                    descending = false;
                    lowerColumnName = lowerColumnName.substring(0, lowerColumnName.length() - 3).trim();
                }
                if ("key".equals(lowerColumnName)) {
                    fieldName = "issuekey";
                } else if ("summary".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("status".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("resolution".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("assignee".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("reporter".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("type".equals(lowerColumnName)) {
                    fieldName = "issuetype";
                } else if ("priority".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("version".equals(lowerColumnName)) {
                    fieldName = "versions";
                } else if ("fix version".equals(lowerColumnName)) {
                    fieldName = "fixVersions";
                } else if ("component".equals(lowerColumnName)) {
                    fieldName = "components";
                } else if ("created".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("updated".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                }
                if (fieldName != null) {
                    localFilter.append("&sorter/field=");
                    localFilter.append(fieldName);
                    localFilter.append("&sorter/order=");
                    localFilter.append(descending ? "DESC" : "ASC");
                    ++validSortColumnNames;
                    continue;
                }
                this.getLog().error((CharSequence)("maven-changes-plugin: The configured value '" + lowerColumnName + "' for sortColumnNames is not correct."));
            }
        }
        if (validSortColumnNames == 0) {
            this.getLog().error((CharSequence)("maven-changes-plugin: None of the configured sortColumnNames '" + this.sortColumnNames + "' are correct."));
        }
        return localFilter.toString();
    }

    public void doExecute() throws Exception {
        try {
            HttpClient client = new HttpClient();
            HttpClientParams clientParams = client.getParams();
            clientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
            clientParams.setCookiePolicy("compatibility");
            HttpState state = new HttpState();
            HostConfiguration hc = new HostConfiguration();
            client.setHostConfiguration(hc);
            client.setState(state);
            Map<String, String> urlMap = JiraHelper.getJiraUrlAndProjectId(this.project.getIssueManagement().getUrl());
            String jiraUrl = urlMap.get("url");
            this.getLog().debug((CharSequence)("JIRA lives at: " + jiraUrl));
            String jiraId = urlMap.get("id");
            this.determineProxy(jiraUrl, client);
            this.prepareBasicAuthentication(client);
            boolean jiraAuthenticationSuccessful = false;
            if (this.isJiraAuthenticationConfigured()) {
                jiraAuthenticationSuccessful = this.doJiraAuthentication(client, jiraUrl);
            }
            if (this.isJiraAuthenticationConfigured() && jiraAuthenticationSuccessful || !this.isJiraAuthenticationConfigured()) {
                if (jiraId == null || jiraId.length() == 0) {
                    this.log.debug((CharSequence)("The JIRA URL " + this.project.getIssueManagement().getUrl() + " doesn't include a pid, trying to extract it from JIRA."));
                    jiraId = JiraHelper.getPidFromJira(this.log, this.project.getIssueManagement().getUrl(), client);
                }
                if (jiraId == null) {
                    this.getLog().error((CharSequence)"The issue management URL in the POM does not include a pid, and it was not possible to extract it from the page at that URL.");
                } else {
                    String createdFilter;
                    String fullURL = jiraUrl + "/secure/IssueNavigator.jspa?view=rss&pid=" + jiraId;
                    if (this.getFixFor() != null) {
                        fullURL = fullURL + "&fixfor=" + this.getFixFor();
                    }
                    if ((createdFilter = this.createFilter()).charAt(0) != '&') {
                        fullURL = fullURL + "&";
                    }
                    fullURL = fullURL + createdFilter;
                    fullURL = fullURL + "&tempMax=" + this.nbEntriesMax + "&reset=true&decorator=none";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("download jira issues from url " + fullURL));
                    }
                    this.download(client, fullURL);
                }
            }
        }
        catch (Exception e) {
            if (this.project.getIssueManagement() != null) {
                this.getLog().error((CharSequence)("Error accessing " + this.project.getIssueManagement().getUrl()), (Throwable)e);
            }
            this.getLog().error((CharSequence)"Error accessing mock project issues", (Throwable)e);
        }
    }

    protected String getFixFor() {
        return null;
    }

    private void prepareBasicAuthentication(HttpClient client) {
        if (this.webUser != null && this.webUser.length() > 0) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.webUser, this.webPassword);
            this.getLog().debug((CharSequence)("Using username: " + this.webUser + " for Basic Authentication."));
            client.getState().setCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)defaultcreds);
        }
    }

    private boolean doJiraAuthentication(HttpClient client, String jiraUrl) {
        String loginUrl = null;
        StringBuffer loginLink = new StringBuffer(jiraUrl);
        loginLink.append("/login.jsp?os_destination=/secure/");
        try {
            loginLink.append("&os_username=").append(URLEncoder.encode(this.jiraUser, UTF_8));
            String password = null;
            if (this.jiraPassword != null) {
                password = StringUtils.repeat((String)"*", (int)this.jiraPassword.length());
            }
            this.getLog().debug((CharSequence)("Login URL: " + loginLink + "&os_password=" + password));
            loginLink.append("&os_password=").append(URLEncoder.encode(this.jiraPassword, UTF_8));
            loginUrl = loginLink.toString();
            GetMethod loginGet = new GetMethod(loginUrl);
            client.executeMethod((HttpMethod)loginGet);
            if (this.loginSucceeded(loginGet)) {
                this.getLog().debug((CharSequence)"Successfully logged in into JIRA.");
                return true;
            }
            this.getLog().warn((CharSequence)"Was unable to login into JIRA: wrong username and/or password.");
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"Error trying to login into JIRA.", (Throwable)e);
            }
            this.getLog().error((CharSequence)("Error trying to login into JIRA. Cause is: " + e.getLocalizedMessage()));
        }
        return false;
    }

    private boolean isJiraAuthenticationConfigured() {
        return this.jiraUser != null && this.jiraUser.length() > 0 && this.jiraPassword != null;
    }

    private boolean loginSucceeded(GetMethod loginGet) throws IOException {
        String loginFailureResponse = "your username and password are incorrect";
        return loginGet.getResponseBodyAsString().indexOf("your username and password are incorrect") == -1;
    }

    private void determineProxy(String jiraUrl, HttpClient client) {
        Proxy proxy = null;
        String proxyHost = null;
        int proxyPort = 0;
        String proxyUser = null;
        String proxyPass = null;
        if (this.project == null) {
            this.getLog().error((CharSequence)"No project set. No proxy info available.");
            return;
        }
        if (this.settings != null) {
            proxy = this.settings.getActiveProxy();
        }
        if (proxy != null) {
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            URL url = null;
            try {
                url = new URL(jiraUrl);
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("Invalid JIRA URL: " + jiraUrl + ". " + e.getMessage()));
            }
            String jiraHost = null;
            if (url != null) {
                jiraHost = url.getHost();
            }
            if (JiraHelper.validateNonProxyHosts(proxyInfo, jiraHost)) {
                return;
            }
            proxyHost = this.settings.getActiveProxy().getHost();
            proxyPort = this.settings.getActiveProxy().getPort();
            proxyUser = this.settings.getActiveProxy().getUsername();
            proxyPass = this.settings.getActiveProxy().getPassword();
            this.getLog().debug((CharSequence)proxyPass);
        }
        if (proxyHost != null) {
            client.getHostConfiguration().setProxy(proxyHost, proxyPort);
            this.getLog().debug((CharSequence)("Using proxy: " + proxyHost + " at port " + proxyPort));
            if (proxyUser != null) {
                this.getLog().debug((CharSequence)("Using proxy user: " + proxyUser));
                client.getState().setProxyCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(HttpClient cl, String link) {
        block13: {
            try {
                GetMethod gm;
                block14: {
                    gm = new GetMethod(link);
                    this.getLog().info((CharSequence)("Downloading from JIRA at: " + link));
                    gm.setFollowRedirects(true);
                    cl.executeMethod((HttpMethod)gm);
                    StatusLine sl = gm.getStatusLine();
                    if (sl == null) {
                        this.getLog().error((CharSequence)("Unknown error validating link: " + link));
                        return;
                    }
                    if (gm.getStatusCode() == 302) {
                        Header locationHeader = gm.getResponseHeader("Location");
                        if (locationHeader == null) {
                            this.getLog().warn((CharSequence)"Site sent redirect, but did not set Location header");
                        } else {
                            String newLink = locationHeader.getValue();
                            this.getLog().debug((CharSequence)("Following redirect to " + newLink));
                            this.download(cl, newLink);
                        }
                    }
                    if (gm.getStatusCode() != 200) break block14;
                    InputStream responseBodyStream = gm.getResponseBodyAsStream();
                    if (!this.output.getParentFile().exists()) {
                        this.output.getParentFile().mkdirs();
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(this.output);
                        IOUtil.copy((InputStream)responseBodyStream, (OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        IOUtil.close((InputStream)responseBodyStream);
                        throw throwable;
                    }
                    IOUtil.close((OutputStream)out);
                    IOUtil.close((InputStream)responseBodyStream);
                    this.getLog().debug((CharSequence)"Downloading from JIRA was successful");
                    break block13;
                }
                this.getLog().warn((CharSequence)("Downloading from JIRA failed. Received: [" + gm.getStatusCode() + "]"));
            }
            catch (HttpException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)"Error downloading issues from JIRA:", (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)("Error downloading issues from JIRA url: " + e.getLocalizedMessage()));
                }
            }
            catch (IOException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)"Error downloading issues from JIRA:", (Throwable)e);
                }
                this.getLog().error((CharSequence)("Error downloading issues from JIRA. Cause is " + e.getLocalizedMessage()));
            }
        }
    }

    public List<Issue> getIssueList() throws MojoExecutionException {
        if (this.output.isFile()) {
            JiraXML jira = new JiraXML(this.log, this.jiraDatePattern);
            jira.parseXML(this.output);
            this.getLog().info((CharSequence)("The JIRA version is '" + jira.getJiraVersion() + "'"));
            return jira.getIssueList();
        }
        this.getLog().warn((CharSequence)("JIRA file " + this.output.getPath() + " doesn't exist."));
        return Collections.emptyList();
    }

    public void setJiraDatePattern(String jiraDatePattern) {
        this.jiraDatePattern = jiraDatePattern;
    }

    public void setOutput(File thisOutput) {
        this.output = thisOutput;
    }

    public File getOutput() {
        return this.output;
    }

    public void setMavenProject(Object thisProject) {
        this.project = (MavenProject)thisProject;
    }

    public void setNbEntries(int nbEntries) {
        this.nbEntriesMax = nbEntries;
    }

    public void setStatusIds(String thisStatusIds) {
        this.statusIds = thisStatusIds;
    }

    public void setPriorityIds(String thisPriorityIds) {
        this.priorityIds = thisPriorityIds;
    }

    public void setResolutionIds(String thisResolutionIds) {
        this.resolutionIds = thisResolutionIds;
    }

    public void setSortColumnNames(String thisSortColumnNames) {
        this.sortColumnNames = thisSortColumnNames;
    }

    public void setWebPassword(String thisWebPassword) {
        this.webPassword = thisWebPassword;
    }

    public void setWebUser(String thisWebUser) {
        this.webUser = thisWebUser;
    }

    public void setJiraPassword(String thisJiraPassword) {
        this.jiraPassword = thisJiraPassword;
    }

    public void setJiraUser(String thisJiraUser) {
        this.jiraUser = thisJiraUser;
    }

    public void setFilter(String thisFilter) {
        this.filter = thisFilter;
    }

    public void setComponent(String theseComponents) {
        this.component = theseComponents;
    }

    public void setFixVersionIds(String theseFixVersionIds) {
        this.fixVersionIds = theseFixVersionIds;
    }

    public void setTypeIds(String theseTypeIds) {
        this.typeIds = theseTypeIds;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Log getLog() {
        return this.log;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

