/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.model.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.ModuleSources;
import org.apache.maven.plugins.assembly.model.Repository;
import org.apache.maven.plugins.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class AssemblyXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, Assembly assembly) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(assembly.getModelEncoding(), null);
        this.writeAssembly(assembly, "assembly", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Assembly assembly) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, assembly.getModelEncoding());
        serializer.startDocument(assembly.getModelEncoding(), null);
        this.writeAssembly(assembly, "assembly", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeAssembly(Assembly assembly, String tagName, XmlSerializer serializer) throws IOException {
        serializer.setPrefix("", "http://maven.apache.org/ASSEMBLY/2.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/ASSEMBLY/2.0.0 http://maven.apache.org/xsd/assembly-2.0.0.xsd");
        if (assembly.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(assembly.getId()).endTag(NAMESPACE, "id");
        }
        if (assembly.getFormats() != null && assembly.getFormats().size() > 0) {
            serializer.startTag(NAMESPACE, "formats");
            for (String string : assembly.getFormats()) {
                serializer.startTag(NAMESPACE, "format").text(string).endTag(NAMESPACE, "format");
            }
            serializer.endTag(NAMESPACE, "formats");
        }
        if (!assembly.isIncludeBaseDirectory()) {
            serializer.startTag(NAMESPACE, "includeBaseDirectory").text(String.valueOf(assembly.isIncludeBaseDirectory())).endTag(NAMESPACE, "includeBaseDirectory");
        }
        if (assembly.getBaseDirectory() != null) {
            serializer.startTag(NAMESPACE, "baseDirectory").text(assembly.getBaseDirectory()).endTag(NAMESPACE, "baseDirectory");
        }
        if (assembly.isIncludeSiteDirectory()) {
            serializer.startTag(NAMESPACE, "includeSiteDirectory").text(String.valueOf(assembly.isIncludeSiteDirectory())).endTag(NAMESPACE, "includeSiteDirectory");
        }
        if (assembly.getContainerDescriptorHandlers() != null && assembly.getContainerDescriptorHandlers().size() > 0) {
            serializer.startTag(NAMESPACE, "containerDescriptorHandlers");
            for (ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig : assembly.getContainerDescriptorHandlers()) {
                this.writeContainerDescriptorHandlerConfig(containerDescriptorHandlerConfig, "containerDescriptorHandler", serializer);
            }
            serializer.endTag(NAMESPACE, "containerDescriptorHandlers");
        }
        if (assembly.getModuleSets() != null && assembly.getModuleSets().size() > 0) {
            serializer.startTag(NAMESPACE, "moduleSets");
            for (ModuleSet moduleSet : assembly.getModuleSets()) {
                this.writeModuleSet(moduleSet, "moduleSet", serializer);
            }
            serializer.endTag(NAMESPACE, "moduleSets");
        }
        if (assembly.getFileSets() != null && assembly.getFileSets().size() > 0) {
            serializer.startTag(NAMESPACE, "fileSets");
            for (FileSet fileSet : assembly.getFileSets()) {
                this.writeFileSet(fileSet, "fileSet", serializer);
            }
            serializer.endTag(NAMESPACE, "fileSets");
        }
        if (assembly.getFiles() != null && assembly.getFiles().size() > 0) {
            serializer.startTag(NAMESPACE, "files");
            for (FileItem fileItem : assembly.getFiles()) {
                this.writeFileItem(fileItem, "file", serializer);
            }
            serializer.endTag(NAMESPACE, "files");
        }
        if (assembly.getDependencySets() != null && assembly.getDependencySets().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencySets");
            for (DependencySet dependencySet : assembly.getDependencySets()) {
                this.writeDependencySet(dependencySet, "dependencySet", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencySets");
        }
        if (assembly.getRepositories() != null && assembly.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "repositories");
            for (Repository repository : assembly.getRepositories()) {
                this.writeRepository(repository, "repository", serializer);
            }
            serializer.endTag(NAMESPACE, "repositories");
        }
        if (assembly.getComponentDescriptors() != null && assembly.getComponentDescriptors().size() > 0) {
            serializer.startTag(NAMESPACE, "componentDescriptors");
            for (String string : assembly.getComponentDescriptors()) {
                serializer.startTag(NAMESPACE, "componentDescriptor").text(string).endTag(NAMESPACE, "componentDescriptor");
            }
            serializer.endTag(NAMESPACE, "componentDescriptors");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeContainerDescriptorHandlerConfig(ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (containerDescriptorHandlerConfig.getHandlerName() != null) {
            serializer.startTag(NAMESPACE, "handlerName").text(containerDescriptorHandlerConfig.getHandlerName()).endTag(NAMESPACE, "handlerName");
        }
        if (containerDescriptorHandlerConfig.getConfiguration() != null) {
            ((Xpp3Dom)containerDescriptorHandlerConfig.getConfiguration()).writeToSerializer(NAMESPACE, serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDependencySet(DependencySet dependencySet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dependencySet.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "outputDirectory").text(dependencySet.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
        }
        if (dependencySet.getIncludes() != null && dependencySet.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : dependencySet.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (dependencySet.getExcludes() != null && dependencySet.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : dependencySet.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (dependencySet.getFileMode() != null) {
            serializer.startTag(NAMESPACE, "fileMode").text(dependencySet.getFileMode()).endTag(NAMESPACE, "fileMode");
        }
        if (dependencySet.getDirectoryMode() != null) {
            serializer.startTag(NAMESPACE, "directoryMode").text(dependencySet.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
        }
        if (dependencySet.isUseStrictFiltering()) {
            serializer.startTag(NAMESPACE, "useStrictFiltering").text(String.valueOf(dependencySet.isUseStrictFiltering())).endTag(NAMESPACE, "useStrictFiltering");
        }
        if (dependencySet.getOutputFileNameMapping() != null && !dependencySet.getOutputFileNameMapping().equals("${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}")) {
            serializer.startTag(NAMESPACE, "outputFileNameMapping").text(dependencySet.getOutputFileNameMapping()).endTag(NAMESPACE, "outputFileNameMapping");
        }
        if (dependencySet.isUnpack()) {
            serializer.startTag(NAMESPACE, "unpack").text(String.valueOf(dependencySet.isUnpack())).endTag(NAMESPACE, "unpack");
        }
        if (dependencySet.getUnpackOptions() != null) {
            this.writeUnpackOptions(dependencySet.getUnpackOptions(), "unpackOptions", serializer);
        }
        if (dependencySet.getScope() != null && !dependencySet.getScope().equals("runtime")) {
            serializer.startTag(NAMESPACE, "scope").text(dependencySet.getScope()).endTag(NAMESPACE, "scope");
        }
        if (!dependencySet.isUseProjectArtifact()) {
            serializer.startTag(NAMESPACE, "useProjectArtifact").text(String.valueOf(dependencySet.isUseProjectArtifact())).endTag(NAMESPACE, "useProjectArtifact");
        }
        if (dependencySet.isUseProjectAttachments()) {
            serializer.startTag(NAMESPACE, "useProjectAttachments").text(String.valueOf(dependencySet.isUseProjectAttachments())).endTag(NAMESPACE, "useProjectAttachments");
        }
        if (!dependencySet.isUseTransitiveDependencies()) {
            serializer.startTag(NAMESPACE, "useTransitiveDependencies").text(String.valueOf(dependencySet.isUseTransitiveDependencies())).endTag(NAMESPACE, "useTransitiveDependencies");
        }
        if (dependencySet.isUseTransitiveFiltering()) {
            serializer.startTag(NAMESPACE, "useTransitiveFiltering").text(String.valueOf(dependencySet.isUseTransitiveFiltering())).endTag(NAMESPACE, "useTransitiveFiltering");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeFileItem(FileItem fileItem, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (fileItem.getSource() != null) {
            serializer.startTag(NAMESPACE, "source").text(fileItem.getSource()).endTag(NAMESPACE, "source");
        }
        if (fileItem.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "outputDirectory").text(fileItem.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
        }
        if (fileItem.getDestName() != null) {
            serializer.startTag(NAMESPACE, "destName").text(fileItem.getDestName()).endTag(NAMESPACE, "destName");
        }
        if (fileItem.getFileMode() != null) {
            serializer.startTag(NAMESPACE, "fileMode").text(fileItem.getFileMode()).endTag(NAMESPACE, "fileMode");
        }
        if (fileItem.getLineEnding() != null) {
            serializer.startTag(NAMESPACE, "lineEnding").text(fileItem.getLineEnding()).endTag(NAMESPACE, "lineEnding");
        }
        if (fileItem.isFiltered()) {
            serializer.startTag(NAMESPACE, "filtered").text(String.valueOf(fileItem.isFiltered())).endTag(NAMESPACE, "filtered");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!fileSet.isUseDefaultExcludes()) {
            serializer.startTag(NAMESPACE, "useDefaultExcludes").text(String.valueOf(fileSet.isUseDefaultExcludes())).endTag(NAMESPACE, "useDefaultExcludes");
        }
        if (fileSet.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "outputDirectory").text(fileSet.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
        }
        if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : fileSet.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : fileSet.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (fileSet.getFileMode() != null) {
            serializer.startTag(NAMESPACE, "fileMode").text(fileSet.getFileMode()).endTag(NAMESPACE, "fileMode");
        }
        if (fileSet.getDirectoryMode() != null) {
            serializer.startTag(NAMESPACE, "directoryMode").text(fileSet.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
        }
        if (fileSet.getDirectory() != null) {
            serializer.startTag(NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(NAMESPACE, "directory");
        }
        if (fileSet.getLineEnding() != null) {
            serializer.startTag(NAMESPACE, "lineEnding").text(fileSet.getLineEnding()).endTag(NAMESPACE, "lineEnding");
        }
        if (fileSet.isFiltered()) {
            serializer.startTag(NAMESPACE, "filtered").text(String.valueOf(fileSet.isFiltered())).endTag(NAMESPACE, "filtered");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (groupVersionAlignment.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(groupVersionAlignment.getId()).endTag(NAMESPACE, "id");
        }
        if (groupVersionAlignment.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(groupVersionAlignment.getVersion()).endTag(NAMESPACE, "version");
        }
        if (groupVersionAlignment.getExcludes() != null && groupVersionAlignment.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : groupVersionAlignment.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeModuleBinaries(ModuleBinaries moduleBinaries, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (moduleBinaries.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "outputDirectory").text(moduleBinaries.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
        }
        if (moduleBinaries.getIncludes() != null && moduleBinaries.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : moduleBinaries.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (moduleBinaries.getExcludes() != null && moduleBinaries.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : moduleBinaries.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (moduleBinaries.getFileMode() != null) {
            serializer.startTag(NAMESPACE, "fileMode").text(moduleBinaries.getFileMode()).endTag(NAMESPACE, "fileMode");
        }
        if (moduleBinaries.getDirectoryMode() != null) {
            serializer.startTag(NAMESPACE, "directoryMode").text(moduleBinaries.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
        }
        if (moduleBinaries.getAttachmentClassifier() != null) {
            serializer.startTag(NAMESPACE, "attachmentClassifier").text(moduleBinaries.getAttachmentClassifier()).endTag(NAMESPACE, "attachmentClassifier");
        }
        if (!moduleBinaries.isIncludeDependencies()) {
            serializer.startTag(NAMESPACE, "includeDependencies").text(String.valueOf(moduleBinaries.isIncludeDependencies())).endTag(NAMESPACE, "includeDependencies");
        }
        if (moduleBinaries.getDependencySets() != null && moduleBinaries.getDependencySets().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencySets");
            for (DependencySet o : moduleBinaries.getDependencySets()) {
                this.writeDependencySet(o, "dependencySet", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencySets");
        }
        if (!moduleBinaries.isUnpack()) {
            serializer.startTag(NAMESPACE, "unpack").text(String.valueOf(moduleBinaries.isUnpack())).endTag(NAMESPACE, "unpack");
        }
        if (moduleBinaries.getUnpackOptions() != null) {
            this.writeUnpackOptions(moduleBinaries.getUnpackOptions(), "unpackOptions", serializer);
        }
        if (moduleBinaries.getOutputFileNameMapping() != null && !moduleBinaries.getOutputFileNameMapping().equals("${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}")) {
            serializer.startTag(NAMESPACE, "outputFileNameMapping").text(moduleBinaries.getOutputFileNameMapping()).endTag(NAMESPACE, "outputFileNameMapping");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeModuleSet(ModuleSet moduleSet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (moduleSet.isUseAllReactorProjects()) {
            serializer.startTag(NAMESPACE, "useAllReactorProjects").text(String.valueOf(moduleSet.isUseAllReactorProjects())).endTag(NAMESPACE, "useAllReactorProjects");
        }
        if (!moduleSet.isIncludeSubModules()) {
            serializer.startTag(NAMESPACE, "includeSubModules").text(String.valueOf(moduleSet.isIncludeSubModules())).endTag(NAMESPACE, "includeSubModules");
        }
        if (moduleSet.getIncludes() != null && moduleSet.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : moduleSet.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (moduleSet.getExcludes() != null && moduleSet.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : moduleSet.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (moduleSet.getSources() != null) {
            this.writeModuleSources(moduleSet.getSources(), "sources", serializer);
        }
        if (moduleSet.getBinaries() != null) {
            this.writeModuleBinaries(moduleSet.getBinaries(), "binaries", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeModuleSources(ModuleSources moduleSources, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!moduleSources.isUseDefaultExcludes()) {
            serializer.startTag(NAMESPACE, "useDefaultExcludes").text(String.valueOf(moduleSources.isUseDefaultExcludes())).endTag(NAMESPACE, "useDefaultExcludes");
        }
        if (moduleSources.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "outputDirectory").text(moduleSources.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
        }
        if (moduleSources.getIncludes() != null && moduleSources.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : moduleSources.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (moduleSources.getExcludes() != null && moduleSources.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : moduleSources.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (moduleSources.getFileMode() != null) {
            serializer.startTag(NAMESPACE, "fileMode").text(moduleSources.getFileMode()).endTag(NAMESPACE, "fileMode");
        }
        if (moduleSources.getDirectoryMode() != null) {
            serializer.startTag(NAMESPACE, "directoryMode").text(moduleSources.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
        }
        if (moduleSources.getFileSets() != null && moduleSources.getFileSets().size() > 0) {
            serializer.startTag(NAMESPACE, "fileSets");
            for (FileSet o : moduleSources.getFileSets()) {
                this.writeFileSet(o, "fileSet", serializer);
            }
            serializer.endTag(NAMESPACE, "fileSets");
        }
        if (!moduleSources.isIncludeModuleDirectory()) {
            serializer.startTag(NAMESPACE, "includeModuleDirectory").text(String.valueOf(moduleSources.isIncludeModuleDirectory())).endTag(NAMESPACE, "includeModuleDirectory");
        }
        if (!moduleSources.isExcludeSubModuleDirectories()) {
            serializer.startTag(NAMESPACE, "excludeSubModuleDirectories").text(String.valueOf(moduleSources.isExcludeSubModuleDirectories())).endTag(NAMESPACE, "excludeSubModuleDirectories");
        }
        if (moduleSources.getOutputDirectoryMapping() != null && !moduleSources.getOutputDirectoryMapping().equals("${module.artifactId}")) {
            serializer.startTag(NAMESPACE, "outputDirectoryMapping").text(moduleSources.getOutputDirectoryMapping()).endTag(NAMESPACE, "outputDirectoryMapping");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (repository.getOutputDirectory() != null) {
            serializer.startTag(NAMESPACE, "outputDirectory").text(repository.getOutputDirectory()).endTag(NAMESPACE, "outputDirectory");
        }
        if (repository.getIncludes() != null && repository.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : repository.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (repository.getExcludes() != null && repository.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : repository.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (repository.getFileMode() != null) {
            serializer.startTag(NAMESPACE, "fileMode").text(repository.getFileMode()).endTag(NAMESPACE, "fileMode");
        }
        if (repository.getDirectoryMode() != null) {
            serializer.startTag(NAMESPACE, "directoryMode").text(repository.getDirectoryMode()).endTag(NAMESPACE, "directoryMode");
        }
        if (repository.isIncludeMetadata()) {
            serializer.startTag(NAMESPACE, "includeMetadata").text(String.valueOf(repository.isIncludeMetadata())).endTag(NAMESPACE, "includeMetadata");
        }
        if (repository.getGroupVersionAlignments() != null && repository.getGroupVersionAlignments().size() > 0) {
            serializer.startTag(NAMESPACE, "groupVersionAlignments");
            for (GroupVersionAlignment o : repository.getGroupVersionAlignments()) {
                this.writeGroupVersionAlignment(o, "groupVersionAlignment", serializer);
            }
            serializer.endTag(NAMESPACE, "groupVersionAlignments");
        }
        if (repository.getScope() != null && !repository.getScope().equals("runtime")) {
            serializer.startTag(NAMESPACE, "scope").text(repository.getScope()).endTag(NAMESPACE, "scope");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeUnpackOptions(UnpackOptions unpackOptions, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (unpackOptions.getIncludes() != null && unpackOptions.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : unpackOptions.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (unpackOptions.getExcludes() != null && unpackOptions.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : unpackOptions.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (unpackOptions.isFiltered()) {
            serializer.startTag(NAMESPACE, "filtered").text(String.valueOf(unpackOptions.isFiltered())).endTag(NAMESPACE, "filtered");
        }
        if (unpackOptions.getLineEnding() != null) {
            serializer.startTag(NAMESPACE, "lineEnding").text(unpackOptions.getLineEnding()).endTag(NAMESPACE, "lineEnding");
        }
        if (!unpackOptions.isUseDefaultExcludes()) {
            serializer.startTag(NAMESPACE, "useDefaultExcludes").text(String.valueOf(unpackOptions.isUseDefaultExcludes())).endTag(NAMESPACE, "useDefaultExcludes");
        }
        if (unpackOptions.getEncoding() != null) {
            serializer.startTag(NAMESPACE, "encoding").text(unpackOptions.getEncoding()).endTag(NAMESPACE, "encoding");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

