/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.GroupKey;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractorComparator;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

@Named
public class DefaultMojoScanner
extends AbstractLogEnabled
implements MojoScanner {
    private Map<String, MojoDescriptorExtractor> mojoDescriptorExtractors;
    private Set<String> activeExtractors;

    @Inject
    public DefaultMojoScanner(Map<String, MojoDescriptorExtractor> extractors) {
        this.mojoDescriptorExtractors = extractors;
        this.enableLogging((Logger)new ConsoleLogger(1, "standalone-scanner-logger"));
    }

    public DefaultMojoScanner() {
    }

    @Override
    public void populatePluginDescriptor(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        Logger logger = this.getLogger();
        int numMojoDescriptors = 0;
        List<MojoDescriptorExtractor> orderedExtractors = this.getOrderedExtractors();
        logger.debug("Using " + orderedExtractors.size() + " mojo extractors.");
        HashMap<String, Integer> groupStats = new HashMap<String, Integer>();
        for (MojoDescriptorExtractor extractor : orderedExtractors) {
            GroupKey groupKey = extractor.getGroupKey();
            String extractorId = extractor.getName();
            logger.debug("Applying " + extractorId + " mojo extractor");
            List<MojoDescriptor> extractorDescriptors = extractor.execute(request);
            int extractorDescriptorsCount = extractorDescriptors.size();
            logger.info(extractorId + " mojo extractor found " + extractorDescriptorsCount + " mojo descriptor" + (extractorDescriptorsCount > 1 ? "s" : "") + ".");
            numMojoDescriptors += extractorDescriptorsCount;
            if (extractor.isDeprecated() && extractorDescriptorsCount > 0) {
                logger.warn("");
                logger.warn("Deprecated extractor " + extractorId + " extracted " + extractorDescriptorsCount + " descriptor" + (extractorDescriptorsCount > 1 ? "s" : "") + ". Upgrade your Mojo definitions.");
                if ("java".equals(groupKey.getGroup())) {
                    logger.warn("You should use Mojo Annotations instead of Javadoc tags.");
                }
                logger.warn("");
            }
            if (groupStats.containsKey(groupKey.getGroup())) {
                groupStats.put(groupKey.getGroup(), (Integer)groupStats.get(groupKey.getGroup()) + extractorDescriptorsCount);
            } else {
                groupStats.put(groupKey.getGroup(), extractorDescriptorsCount);
            }
            for (MojoDescriptor descriptor : extractorDescriptors) {
                logger.debug("Adding mojo: " + descriptor + " to plugin descriptor.");
                descriptor.setPluginDescriptor(request.getPluginDescriptor());
                request.getPluginDescriptor().addMojo(descriptor);
            }
        }
        logger.debug("Discovered descriptors by groups: " + groupStats);
        if (numMojoDescriptors == 0 && !request.isSkipErrorNoDescriptorsFound()) {
            throw new InvalidPluginDescriptorException("No mojo definitions were found for plugin: " + request.getPluginDescriptor().getPluginLookupKey() + ".");
        }
    }

    private List<MojoDescriptorExtractor> getOrderedExtractors() throws ExtractionException {
        Set<String> extractors = this.activeExtractors;
        if (extractors == null) {
            extractors = new HashSet<String>(this.mojoDescriptorExtractors.keySet());
        }
        ArrayList<MojoDescriptorExtractor> orderedExtractors = new ArrayList<MojoDescriptorExtractor>();
        for (String extractorId : extractors) {
            MojoDescriptorExtractor extractor = this.mojoDescriptorExtractors.get(extractorId);
            if (extractor == null) {
                throw new ExtractionException("No mojo extractor with '" + extractorId + "' id.");
            }
            orderedExtractors.add(extractor);
        }
        Collections.sort(orderedExtractors, MojoDescriptorExtractorComparator.INSTANCE);
        return orderedExtractors;
    }

    @Override
    public void setActiveExtractors(Set<String> extractors) {
        if (extractors == null) {
            this.activeExtractors = null;
        } else {
            this.activeExtractors = new HashSet<String>();
            for (String extractor : extractors) {
                if (extractor == null || extractor.isEmpty()) continue;
                this.activeExtractors.add(extractor);
            }
        }
    }
}

