/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.javadoc;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavadocReference {
    private final Optional<String> moduleName;
    private final Optional<String> packageNameClassName;
    private final Optional<String> member;
    private final Optional<String> label;
    private static final Pattern REFERENCE_VALUE_PATTERN = Pattern.compile("^\\s*(?:(.+)/)??([^#\\s/]+)?(?:#([^\\s\\(]+(?:\\([^\\)]*\\))?))?(?: +(.*))?$");
    private static final int GROUP_INDEX_MODULE = 1;
    private static final int GROUP_INDEX_PACKAGECLASS = 2;
    private static final int GROUP_INDEX_MEMBER = 3;
    private static final int GROUP_INDEX_LABEL = 4;

    public static JavadocReference parse(String reference) {
        Matcher matcher = REFERENCE_VALUE_PATTERN.matcher(reference);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid format of javadoc reference: " + reference);
        }
        Optional<String> moduleName = JavadocReference.getOptionalGroup(matcher, 1);
        Optional<String> packageNameClassName = JavadocReference.getOptionalGroup(matcher, 2);
        Optional<String> member = JavadocReference.getOptionalGroup(matcher, 3);
        Optional<String> label = JavadocReference.getOptionalGroup(matcher, 4);
        return new JavadocReference(moduleName, packageNameClassName, member, label);
    }

    private static Optional<String> getOptionalGroup(Matcher matcher, int index) {
        String group = matcher.group(index);
        if (group != null && !group.isEmpty()) {
            return Optional.of(group);
        }
        return Optional.empty();
    }

    JavadocReference(Optional<String> moduleName, Optional<String> packageNameClassName, Optional<String> member, Optional<String> label) {
        this.moduleName = moduleName;
        this.packageNameClassName = packageNameClassName;
        this.member = member;
        this.label = label;
    }

    public Optional<String> getModuleName() {
        return this.moduleName;
    }

    public Optional<String> getPackageNameClassName() {
        return this.packageNameClassName;
    }

    public Optional<String> getMember() {
        return this.member;
    }

    public Optional<String> getLabel() {
        return this.label;
    }

    public String toString() {
        return "JavadocReference [moduleName=" + this.moduleName + ", packageNameClassName=" + this.packageNameClassName + ", member=" + this.member + ", label=" + this.label + "]";
    }

    public int hashCode() {
        return Objects.hash(this.label, this.member, this.packageNameClassName, this.moduleName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavadocReference other = (JavadocReference)obj;
        return Objects.equals(this.label, other.label) && Objects.equals(this.member, other.member) && Objects.equals(this.packageNameClassName, other.packageNameClassName) && Objects.equals(this.moduleName, other.moduleName);
    }
}

