/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.Requirement;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginDescriptorGenerator
implements Generator {
    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        this.execute(destinationDirectory, new DefaultPluginToolsRequest(null, pluginDescriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File destinationDirectory, PluginToolsRequest request) throws IOException {
        PluginDescriptor pluginDescriptor = request.getPluginDescriptor();
        String encoding = "UTF-8";
        File f = new File(destinationDirectory, "plugin.xml");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding);
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer, encoding, null);
            w.startElement("plugin");
            PluginUtils.element((XMLWriter)w, "name", pluginDescriptor.getName());
            PluginUtils.element((XMLWriter)w, "description", pluginDescriptor.getDescription());
            PluginUtils.element((XMLWriter)w, "groupId", pluginDescriptor.getGroupId());
            PluginUtils.element((XMLWriter)w, "artifactId", pluginDescriptor.getArtifactId());
            PluginUtils.element((XMLWriter)w, "version", pluginDescriptor.getVersion());
            PluginUtils.element((XMLWriter)w, "goalPrefix", pluginDescriptor.getGoalPrefix());
            PluginUtils.element((XMLWriter)w, "isolatedRealm", "" + pluginDescriptor.isIsolatedRealm());
            PluginUtils.element((XMLWriter)w, "inheritedByDefault", "" + pluginDescriptor.isInheritedByDefault());
            w.startElement("mojos");
            if (pluginDescriptor.getMojos() != null) {
                Iterator it = pluginDescriptor.getMojos().iterator();
                while (it.hasNext()) {
                    MojoDescriptor descriptor = (MojoDescriptor)it.next();
                    this.processMojoDescriptor(descriptor, (XMLWriter)w);
                }
            }
            w.endElement();
            PluginUtils.writeDependencies((XMLWriter)w, pluginDescriptor);
            w.endElement();
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w) {
        Parameter parameter;
        w.startElement("mojo");
        w.startElement("goal");
        w.writeText(mojoDescriptor.getGoal());
        w.endElement();
        String description = mojoDescriptor.getDescription();
        if (description != null) {
            w.startElement("description");
            w.writeText(mojoDescriptor.getDescription());
            w.endElement();
        }
        if (mojoDescriptor.isDependencyResolutionRequired() != null) {
            PluginUtils.element(w, "requiresDependencyResolution", mojoDescriptor.isDependencyResolutionRequired());
        }
        PluginUtils.element(w, "requiresDirectInvocation", "" + mojoDescriptor.isDirectInvocationOnly());
        PluginUtils.element(w, "requiresProject", "" + mojoDescriptor.isProjectRequired());
        PluginUtils.element(w, "requiresReports", "" + mojoDescriptor.isRequiresReports());
        PluginUtils.element(w, "aggregator", "" + mojoDescriptor.isAggregator());
        PluginUtils.element(w, "requiresOnline", "" + mojoDescriptor.isOnlineRequired());
        PluginUtils.element(w, "inheritedByDefault", "" + mojoDescriptor.isInheritedByDefault());
        if (mojoDescriptor.getPhase() != null) {
            PluginUtils.element(w, "phase", mojoDescriptor.getPhase());
        }
        if (mojoDescriptor.getExecutePhase() != null) {
            PluginUtils.element(w, "executePhase", mojoDescriptor.getExecutePhase());
        }
        if (mojoDescriptor.getExecuteGoal() != null) {
            PluginUtils.element(w, "executeGoal", mojoDescriptor.getExecuteGoal());
        }
        if (mojoDescriptor.getExecuteLifecycle() != null) {
            PluginUtils.element(w, "executeLifecycle", mojoDescriptor.getExecuteLifecycle());
        }
        w.startElement("implementation");
        w.writeText(mojoDescriptor.getImplementation());
        w.endElement();
        w.startElement("language");
        w.writeText(mojoDescriptor.getLanguage());
        w.endElement();
        if (mojoDescriptor.getComponentConfigurator() != null) {
            w.startElement("configurator");
            w.writeText(mojoDescriptor.getComponentConfigurator());
            w.endElement();
        }
        if (mojoDescriptor.getComponentComposer() != null) {
            w.startElement("composer");
            w.writeText(mojoDescriptor.getComponentComposer());
            w.endElement();
        }
        w.startElement("instantiationStrategy");
        w.writeText(mojoDescriptor.getInstantiationStrategy());
        w.endElement();
        w.startElement("executionStrategy");
        w.writeText(mojoDescriptor.getExecutionStrategy());
        w.endElement();
        if (mojoDescriptor.getDeprecated() != null) {
            w.startElement("deprecated");
            if (StringUtils.isEmpty((String)mojoDescriptor.getDeprecated())) {
                w.writeText("No reason given");
            } else {
                w.writeText(mojoDescriptor.getDeprecated());
            }
            w.endElement();
        }
        List parameters = mojoDescriptor.getParameters();
        w.startElement("parameters");
        HashMap<String, Requirement> requirements = new HashMap<String, Requirement>();
        HashSet<Parameter> configuration = new HashSet<Parameter>();
        if (parameters != null) {
            for (int j = 0; j < parameters.size(); ++j) {
                parameter = (Parameter)parameters.get(j);
                String expression = parameter.getExpression();
                if (StringUtils.isNotEmpty((String)expression) && expression.startsWith("${component.")) {
                    String role = expression.substring("${component.".length(), expression.length() - 1);
                    String roleHint = null;
                    int posRoleHintSeparator = role.indexOf("#");
                    if (posRoleHintSeparator > 0) {
                        roleHint = role.substring(posRoleHintSeparator + 1);
                        role = role.substring(0, posRoleHintSeparator);
                    }
                    requirements.put(parameter.getName(), new Requirement(role, roleHint));
                    continue;
                }
                if (parameter.getRequirement() != null) {
                    requirements.put(parameter.getName(), parameter.getRequirement());
                    continue;
                }
                w.startElement("parameter");
                PluginUtils.element(w, "name", parameter.getName());
                if (parameter.getAlias() != null) {
                    PluginUtils.element(w, "alias", parameter.getAlias());
                }
                PluginUtils.element(w, "type", parameter.getType());
                if (parameter.getDeprecated() != null) {
                    if (StringUtils.isEmpty((String)parameter.getDeprecated())) {
                        PluginUtils.element(w, "deprecated", "No reason given");
                    } else {
                        PluginUtils.element(w, "deprecated", parameter.getDeprecated());
                    }
                }
                if (parameter.getImplementation() != null) {
                    PluginUtils.element(w, "implementation", parameter.getImplementation());
                }
                PluginUtils.element(w, "required", Boolean.toString(parameter.isRequired()));
                PluginUtils.element(w, "editable", Boolean.toString(parameter.isEditable()));
                PluginUtils.element(w, "description", parameter.getDescription());
                if (StringUtils.isNotEmpty((String)parameter.getDefaultValue()) || StringUtils.isNotEmpty((String)parameter.getExpression())) {
                    configuration.add(parameter);
                }
                w.endElement();
            }
        }
        w.endElement();
        if (!configuration.isEmpty()) {
            w.startElement("configuration");
            Iterator i = configuration.iterator();
            while (i.hasNext()) {
                parameter = (Parameter)i.next();
                w.startElement(parameter.getName());
                String type = parameter.getType();
                if (type != null) {
                    w.addAttribute("implementation", type);
                }
                if (parameter.getDefaultValue() != null) {
                    w.addAttribute("default-value", parameter.getDefaultValue());
                }
                if (parameter.getExpression() != null) {
                    w.writeText(parameter.getExpression());
                }
                w.endElement();
            }
            w.endElement();
        }
        if (!requirements.isEmpty()) {
            w.startElement("requirements");
            Iterator i = requirements.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Requirement requirement = (Requirement)requirements.get(key);
                w.startElement("requirement");
                PluginUtils.element(w, "role", requirement.getRole());
                if (requirement.getRoleHint() != null) {
                    PluginUtils.element(w, "role-hint", requirement.getRoleHint());
                }
                PluginUtils.element(w, "field-name", key);
                w.endElement();
            }
            w.endElement();
        }
        w.endElement();
    }
}

